EvaluateScript("mouse_manage.js");
EvaluateScript("auto.js");
EvaluateScript("intro.js");
EvaluateScript("gore.js");
EvaluateScript("explode.js");
EvaluateScript("player_update.js");
EvaluateScript("debug.js");
EvaluateScript("ai.js");
EvaluateScript("shells.js");
EvaluateScript("wave.js");
EvaluateScript("doors.js");
EvaluateScript("zone.js");
EvaluateScript("terminal.js");
EvaluateScript("audio.js");
EvaluateScript("keys.js");
EvaluateScript("clear.js");
EvaluateScript("maps.js");
EvaluateScript("level.js");
EvaluateScript("recording.js");
EvaluateScript("water.js");
EvaluateScript("supernaut.js");
EvaluateScript("math_stuff.js");
EvaluateScript("ending.js");
EvaluateScript("tower.js");
EvaluateScript("boss.js");
EvaluateScript("gray.js");
EvaluateScript("barrel.js");
EvaluateScript("damage.js");
EvaluateScript("training.js");
EvaluateScript("ammotext.js");

var font = GetSystemFont();

var entities = new Array()
var max_entities = 60;
for (i=0;i<max_entities;i++)
{
	entities[i] = new Object();
	entities[i].x = 0;
	entities[i].y = 0;
	entities[i].vx = 0;
	entities[i].vy = 0;
	entities[i].dir = 1;
	entities[i].dir1 = "";
	entities[i].dir2 = "";
	entities[i].bdir = "";
	entities[i].frame1 = 0;
	entities[i].frame2 = 0;
	entities[i].mask = CreateColor(128,128,128, 255);

	entities[i].hp = 1;
	entities[i].hp1 = 1;//arm1
	entities[i].hp2 = 1;//arm2
	entities[i].hp3 = 1;//legs
	entities[i].name = "enemy"+i;
	entities[i].spriteset = "";
	entities[i].type = -1;
	entities[i].invince = 0;
	entities[i].active = false;
	entities[i].ambush = false;
}

SetupHeads();

var max_entity_types = 15;
var entity_frames = new Array(max_entity_types);
var entity_misc = new Array(max_entity_types);
for (i=0;i<max_entity_types;i++)
{
	entity_frames[i] = new Object();
	entity_misc[i] = new Object();
}

var g_umber_hp = 30;
var g_guard_hp = 40;


entity_frames[1].die = 8;
entity_frames[1].injury = 1;
entity_frames[1].attack = 6;
entity_frames[1].legwalk = 4;
entity_frames[1].legdie = 2;

entity_frames[2].die = 2;
entity_frames[2].injury = 2;
entity_frames[2].attack = 2;
entity_frames[2].legwalk = 2;
entity_frames[2].legdie = 2;

entity_frames[3].die = 8;
entity_frames[3].injury = 1;
entity_frames[3].attack = 6;
entity_frames[3].legwalk = 4;
entity_frames[3].legdie = 2;

entity_frames[5].die = 8;
entity_frames[5].injury = 1;
entity_frames[5].attack = 6;
entity_frames[5].legwalk = 4;
entity_frames[5].legdie = 7;

entity_frames[6].die = 43;
entity_frames[6].injury = 1;
entity_frames[6].attack = 10;
entity_frames[6].attack2 = 7;
entity_frames[6].attack3 = 18;
entity_frames[6].attack4 = 10;
entity_frames[6].legwalk = 13;
entity_frames[6].legdie = 7;
entity_frames[6].armregen = 7;


entity_frames[7].die = 14;
entity_frames[7].injury = 1;
entity_frames[7].attack = 6;
entity_frames[7].rise = 4;
//entity_frames[7].legwalk = 4;
//entity_frames[7].legdie = 2;

entity_frames[8].die = 14;
entity_frames[8].attack = 9;

entity_frames[9].die = 10;
entity_frames[9].attack = 9;

entity_frames[10].die = 11;
entity_frames[10].attack = 9;

entity_frames[11].die = 1;
entity_frames[11].idle = 4;


entity_frames[12].die = 7;
entity_frames[12].injury = 1;
entity_frames[12].attack = 6;
entity_frames[12].attack2 = 6;
entity_frames[12].attack3 = 6;



entity_misc[0].damage = 0;//normal:just body
entity_misc[1].damage = 1;//normal:head,arms,leg
entity_misc[2].damage = 0;//normal:just body
entity_misc[3].damage = 1;//normal:head,arms,leg
entity_misc[4].damage = 2;//wipe type: stun,
entity_misc[5].damage = 1;//normal:head,arms,leg
entity_misc[6].damage = 2;//normal:head,arms,leg
entity_misc[7].damage = 3;//normal:head,arms
entity_misc[8].damage = 3;//normal:head,arms
entity_misc[9].damage = 0;//normal:just body
entity_misc[10].damage = 0;//normal:just body
entity_misc[11].damage = 0;//normal:just body
entity_misc[12].damage = 0;//normal:just body

entity_misc[0].blood  = 1;//has blood
entity_misc[1].blood  = 1;//has blood
entity_misc[2].blood  = 0;//no blood
entity_misc[3].blood  = 1;//has blood
entity_misc[4].blood  = 0;//no blood
entity_misc[5].blood  = 1;//has blood
entity_misc[6].blood  = 1;//has blood
entity_misc[7].blood  = 1;//has blood
entity_misc[8].blood  = 1;//has blood
entity_misc[9].blood  = 1;//has blood
entity_misc[10].blood  = 0;//has blood
entity_misc[11].blood  = 1;//has blood
entity_misc[12].blood  = 1;//has blood

entity_misc[0].legs  = 1;//has legs to blow off
entity_misc[1].legs  = 1;//has legs to blow off
entity_misc[2].legs  = 1;//has legs to blow off
entity_misc[3].legs  = 1;//has legs to blow off
entity_misc[4].legs  = 1;//has legs to blow off
entity_misc[5].legs  = 0;//no legs to blow off
entity_misc[6].legs  = 0;//no legs to blow off
entity_misc[7].legs  = 0;//no legs to blow off
entity_misc[8].legs  = 0;//no legs to blow off
entity_misc[9].legs  = 0;//no legs to blow off
entity_misc[10].legs  = 0;//no legs to blow off
entity_misc[11].legs  = 0;//no legs to blow off
entity_misc[12].legs  = 0;//no legs to blow off


entity_misc[0].atkw  = 4;//
entity_misc[1].atkw  = 4;//
entity_misc[2].atkw  = 4;//
entity_misc[3].atkw  = 4;//
entity_misc[4].atkw  = 4;//
entity_misc[5].atkw  = 6;//
entity_misc[6].atkw  = 7;//
entity_misc[7].atkw  = 7;//
entity_misc[8].atkw  = 6;//
entity_misc[9].atkw  = 4;//
entity_misc[10].atkw  = 4;//
entity_misc[11].atkw  = 4;//
entity_misc[12].atkw  = 4;//

entity_misc[0].atkw2  = 4;//
entity_misc[1].atkw2  = 4;//
entity_misc[2].atkw2  = 4;//
entity_misc[3].atkw2 = 4;//
entity_misc[4].atkw2 = 4;//
entity_misc[5].atkw2 = 6;//
entity_misc[6].atkw2 = 7;//
entity_misc[7].atkw2 = 7;//
entity_misc[8].atkw2 = 4;//
entity_misc[9].atkw2 = 4;//
entity_misc[10].atkw2  = 4;//
entity_misc[11].atkw2 = 4;//
entity_misc[12].atkw2 = 4*5/6;//


entity_misc[0].atkw3  = 4;//
entity_misc[1].atkw3  = 0;//
entity_misc[2].atkw3  = 2;//
entity_misc[3].atkw3 = 0;//
entity_misc[4].atkw3 = 0;//
entity_misc[5].atkw3 = 0;//
entity_misc[6].atkw3 = 0;//
entity_misc[7].atkw3 = 0;//
entity_misc[8].atkw3 = 0;//
entity_misc[9].atkw3 = 0;//
entity_misc[10].atkw3  = 0;//
entity_misc[11].atkw3 = 0;//
entity_misc[12].atkw3 = 0;//



entity_misc[0].atkh  = 2;//
entity_misc[1].atkh  = 2;//
entity_misc[2].atkh  = 2;//
entity_misc[3].atkh  = 2;//
entity_misc[4].atkh  = 2;//
entity_misc[5].atkh  = 3;//
entity_misc[6].atkh  = 3;//
entity_misc[7].atkh  = 2;//
entity_misc[8].atkh  = 7;//
entity_misc[9].atkh  = 2;//
entity_misc[10].atkh  = 7;//
entity_misc[11].atkh  = 7;//
entity_misc[12].atkh  = 3;//



var max_hp = 10;
var max_stam = 10;

var idarm_hp = 60;

//main character
entities[0].x = 0;
entities[0].y = 0;
entities[0].vx = 0;
entities[0].vy = 0;

entities[0].dir = 1;
entities[0].dir2 = 1;
entities[0].frame1 = 1;
entities[0].frame2 = 1;


entities[0].hp = max_hp;
entities[0].stam = max_stam;
entities[0].name = "main_torso";
entities[0].spriteset = "leigh";
entities[0].type = 0;//main hero character

//ammo amounts
var max_ammos = 16;
var ammo_array = new Array(max_ammos);
for (i=0;i<max_ammos;i++)
{
	ammo_array[i] = new Object();
	ammo_array[i].curclip = 10;//amt in current clip 
	ammo_array[i].clipamt = 10;//max ammo in a clip
	ammo_array[i].maxammo = 10;//max bullets.
	ammo_array[i].curammo = 10;//bullets you have left.
	ammo_array[i].maxclip = 10;//max ammo in a clip


	ammo_array[i].fw1 = 0;//frame wait for firing.
	ammo_array[i].fw2 = 0;
	
	ammo_array[i].aw1 = 2;
	ammo_array[i].aw2 = 2;
	ammo_array[i].aw3 = 1;
	ammo_array[i].aw4 = 0;

	ammo_array[i].damage = 1;
}
//9mm, pistol - 1
ammo_array[0].curclip = 12;
ammo_array[0].maxclip = 12;
ammo_array[0].maxammo = 252;
ammo_array[0].curammo = 120;
ammo_array[0].damage = 2;
ammo_array[0].waterfirable = 1;
ammo_array[0].useammo = 1;

//grenades, hand
ammo_array[1].curclip = 1;
ammo_array[1].maxclip = 1;
ammo_array[1].maxammo = 20;
ammo_array[1].curammo = 6;
ammo_array[1].damage = 10;
ammo_array[1].waterfirable = 1;
ammo_array[1].useammo = 1;



//.45, magnum - 2
ammo_array[2].curclip = 0;//6;
ammo_array[2].maxclip = 6;
ammo_array[2].maxammo = 150;
ammo_array[2].curammo = 0;//10;
ammo_array[2].damage = 4;
ammo_array[2].waterfirable = 1;
ammo_array[2].useammo = 1;

//shells, shotgun (assault?) - 3
ammo_array[3].curclip = 0;//3;
ammo_array[3].maxclip = 3;
ammo_array[3].maxammo = 200;
ammo_array[3].curammo = 0;//10;

ammo_array[3].af2 = 1;

ammo_array[3].damage = 6;
ammo_array[3].waterfirable = 0;
ammo_array[3].useammo = 1;

//9mm, assault - 4
ammo_array[4].curclip = 0;//30;
ammo_array[4].maxclip = 30;
ammo_array[4].maxammo = 300;
ammo_array[4].curammo = 0;//30;

ammo_array[4].fw1 = 0;
ammo_array[4].fw2 = -1;

ammo_array[4].damage = 2;
ammo_array[4].waterfirable = 0;
ammo_array[4].useammo = 1;

//grenades, assault rifle
ammo_array[5].curclip = 0;//1;
ammo_array[5].maxclip = 0;//1;
ammo_array[5].maxammo = 25;
ammo_array[5].curammo = 0;//25;
ammo_array[5].damage = 10;
ammo_array[5].waterfirable = 1;
ammo_array[5].useammo = 1;

//rocket launcher - 5
ammo_array[6].curclip = 0;//1;
ammo_array[6].maxclip = 1;
ammo_array[6].maxammo = 25;
ammo_array[6].curammo = 0;//5;

ammo_array[6].aw1 = 4;
ammo_array[6].aw2 = 4;
ammo_array[6].aw3 = 4;
ammo_array[6].aw4 = 4;

ammo_array[6].damage = 10;
ammo_array[6].waterfirable = 1;
ammo_array[6].useammo = 1;

//railgun - 6
ammo_array[7].curclip = 0;//5;
ammo_array[7].maxclip = 5;
ammo_array[7].maxammo = 150;
ammo_array[7].curammo = 0;//10;

	ammo_array[7].fw1 = 6;
	ammo_array[7].fw2 = 6;

	ammo_array[7].aw1 = -1;
	ammo_array[7].aw2 = 0;
	ammo_array[7].aw3 = 2;
	ammo_array[7].aw4 = 1;

ammo_array[7].damage = 10;
ammo_array[7].waterfirable = 1;
ammo_array[7].useammo = 1;

//flak gun (shoots out schrapnel) - 7
ammo_array[8].curclip = 0;//1;
ammo_array[8].maxclip = 1;
ammo_array[8].maxammo = 100;
ammo_array[8].curammo = 0;//10;

ammo_array[8].damage = 25;
ammo_array[8].waterfirable = 0;
ammo_array[8].useammo = 1;

//obliterator (no aiming, does damage to
//all enemies nearby (gibs them if kill) - 8
ammo_array[9].curclip = 0;//1;
ammo_array[9].maxclip = 1;
ammo_array[9].maxammo = 10;
ammo_array[9].curammo = 0;//2;

ammo_array[9].damage = 50;
ammo_array[9].waterfirable = 1;
ammo_array[9].useammo = 1;

//adren system
ammo_array[10].curclip = 1;
ammo_array[10].maxclip = 1;
ammo_array[10].maxammo = 10;
ammo_array[10].curammo = 5;

ammo_array[10].damage = 20;
ammo_array[10].fw1 = 0;
ammo_array[10].fw2 = -1;
ammo_array[10].useammo = 1;

//armour
ammo_array[11].curclip = 1;
ammo_array[11].maxclip = 1;
ammo_array[11].maxammo = 10;
ammo_array[11].curammo = 4;

ammo_array[11].damage = 20;
ammo_array[11].useammo = 1;


//EXPANDED WEAPONS!
//Chaingun
ammo_array[12].curclip = 0;//200;
ammo_array[12].maxclip = 200;
ammo_array[12].maxammo = 9999;
ammo_array[12].curammo = 0;//8000;

ammo_array[12].damage = 10;
ammo_array[12].waterfirable = 0;
ammo_array[12].useammo = 1;

//Sword
ammo_array[13].curclip = 0;
ammo_array[13].maxclip = 0;
ammo_array[13].maxammo = 0;
ammo_array[13].curammo = 0;

ammo_array[13].damage = 50;
ammo_array[13].waterfirable = 1;
ammo_array[13].useammo = 0;
ammo_array[13].fw1 = 4;
ammo_array[13].fw2 = 4;
ammo_array[13].fw3 = 1;

var adren_sword_bonus = 2;

SaveDamage();

//weapon possession array
var weap_possess = new Array(16);
for (i=0;i<16;i++)
	weap_possess[i] = 0;


weap_possess[0] = 1;
//weap_possess[1] = 1;
//weap_possess[10] = 1;
//weap_possess[11] = 1;




var cur_weap = 0;
var weapon_sets = new Array(16);

//various fonts
var bullet_font = LoadFont("bullet.rfn");
bullet_font.setColorMask(CreateColor(0,160,32, 160));

var font2 = GetSystemFont();
font2.setColorMask(CreateColor(0,160,32, 160));
var font2gl = GetSystemFont();
font2gl.setColorMask(CreateColor(0,160,32, 255));

var font3 = LoadFont("font3.rfn");
font3.setColorMask(CreateColor(0,255,48, 220));

var fonty2 = LoadFont("fonty2.rfn");
fonty2.setColorMask(CreateColor(0,255,48, 220));

var font2b = GetSystemFont();
font2b.setColorMask(CreateColor(0,255,48, 255));

//various constants
var grav_max = 10;
var grav_drone = 8;
var grav_amt = 0.5;

var g_frames = 0;
var g_total_time = 0;
var frameupdate = 2;

//various images
var crosshair = LoadImage("dot.png");
var hud = LoadImage("hud1.png");
var boss_hud = LoadImage("hud_boss1.png");
var bullet_panel = LoadImage("bullet_panel1.png");
var bullet_panel2 = LoadImage("bullet_panel2.png");
var bullet_panel3 = LoadImage("bullet_panel3.png");
var hp_bar = LoadImage("hp_bar1.png");
var stam_bar = LoadImage("stam_bar.png");

var g_current_level = 0;
var g_kills = 0;
var g_total_kills = 0;
var g_fireshift = 0;

function game()
{
	SetupWeaponTexts();
	LoadSoundConfig();
	var auto_reload = ReadResetInfo();
	var numby;
	if (auto_reload > -2)
	{
			LoadSlot(auto_reload);
			numby = 3;
	}
	else if (auto_reload == -5)
	{
		numby = 2;
	}
	else
		numby = Intros();
	
	if (numby == 1)
	{
		g_current_level = 1;
		SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "StartFunct();");
		MapEngine("level01.rmp", 96);
	}
	else if (numby == 2)
	{
		g_current_level = -2;
		SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "StartFunct(-2);");
		MapEngine("training1.rmp", 96);
	}
	else if (numby == 3)
	{
		SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "StartFunct("+g_current_level+");");
		MapEngine("level01.rmp", 96);
	}
}

var g_widthy_id = 0;
var g_bwidthy_id = 0;

var g_cancel_fade = false;
var blood_splat_layer=3;
var g_wipe_active = -1;
var g_id_active = -1;
function StartFunct(level, loop)
{
	TrainingMonsterSave(level);
	g_fall_counter = 0;
	SaveWeapPossess();

	g_wt_counter = -1;
	g_statics = 0;
	SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "");
	g_boss_cc = g_boss_norm;
	g_naut_override = 0;
	g_supernaut_active = -1;
	ResetNaut1();
	ResetNaut2();
	g_wipe_active = -1;
	g_id_active = -1;
	g_boss_active = -1;

	g_cancel_fade = false;
	g_chain_cc = 0;
	g_sword_cc = 0;
	
	for (i=0;i<max_scripts_commands;i++)
		script_commands[i] = "";


	for (i=0;i<map_zones.length;i++)
	{
		map_zones[i] = 0;
	}
  
	g_kills = 0;
	g_diff = g_chosen_diff;
	g_mtransition = -1;	
	LoadDamage(g_chosen_diff);
	
	if (level == undefined)
	{
		ClearGameInfo(1);
		ChangeMap("level01.rmp");
		g_current_level = 1;
		
		g_total_kills = 0;
		g_total_time = 0;
	}
	else
	{
		if (debug_goto_level > 0 && loop != false)
		{
			level = debug_goto_level;
		}
			
		g_current_level = level;
		ClearGameInfo();
		
		if (level == -2)
		{
			ChangeMap("training1.rmp");
		}
		else if (level<10)
			ChangeMap("level0"+level+".rmp");
		else 
			ChangeMap("level"+level+".rmp");
	
		if (level == 13)
		{
			SetupSupernautDrawing();
		}
		if (level == 15)
		{
			//g_supernaut_active = 2;
			SetupSupernautDrawing();
		}
	}

	var grs = "";
	if (level == 18)
		grs = "gray/g_";
	
	g_id_trigger = -1;

	if (level != -2)
		SaveToSlot(-1,"autosave");
  
  if (level == 3)
  {
		SetPersonX("enemy1_legs_30", GetPersonX("enemy1_legs_30")-8);
  }
  else if (level == 7)
  {
		SetPersonX("switch1_2Tdoor1_3c", GetPersonX("switch1_2Tdoor1_3c")-8);
  }
  
  SetPersonDrawOrder(2);
  
	g_fireshift = 0;
	LayerShiftClear();
  //setup layer offset if needed
  if ((GetLayerName(GetNumLayers()-1)).substr(0,3) == "sh_")
  {
		//shift this layer over by half a tile
		SetLayerXShift(GetNumLayers()-1, 8);
		SetLayerYShift(GetNumLayers()-1, 7);
		SetLayerYShift(GetNumLayers()-2, 6);
		g_fireshift = 1;
		DoLayerScripts();
  }
  

  magnum_shot = 0;
  shell_shot = 0;
  rail_shot = 0;
  shrap_shot = 0;
  
  
  //reset terminal hacking
  g_terminal_hacked = 0;

  for (i=0;i<max_explosions;i++)
  {
		CreatePerson("exp"+i, grs+"explode1.rss", true);
		SetPersonX("exp"+i, -100);
    IgnorePersonObstructions("exp"+i, true);
	}

  for (i=0;i<max_grenades;i++)
  {
		CreatePerson("grenades"+i, grs+"grenades.rss", true);
		SetPersonX("grenades"+i, -100);
    IgnorePersonObstructions("grenades"+i, true);
	}
  
	for (i=0;i<max_trails;i++)
	{
		CreatePerson("bt"+i, "blood.rss", true);
    IgnorePersonObstructions("bt"+i, true);
		SetPersonX("bt"+i, -100);
		SetPersonLayer("bt"+i, blood_layer);
		btrails[i].id1 = GetPersonID("bt"+i);
		btrails[i].x = -100;
		btrails[i].y = 0;
		
		btrails[i].vx = 0;
		btrails[i].vy = 0;
		btrails[i].type = 0;
		btrails[i].frame = 0;
		btrails[i].dir = 0;
		btrails[i].owner = "";
		btrails[i].rotation = 0;
		btrails[i].flamed = 0;
	}

	for (i=0;i<max_beams;i++)
	{
		CreatePerson("beam"+i, grs+"wavebeam.rss", true);
    IgnorePersonObstructions("beam"+i, true);
		SetPersonX("beam"+i, -100);
		SetPersonLayer("beam"+i, blood_layer);
		beams[i].id1 = GetPersonID("beam"+i);
		beams[i].x = -100;
		beams[i].y = -100;
		beams[i].damage = -1
	}

	for (i=0;i<max_spark;i++)
	{
		CreatePerson("ss"+i, "spark_splat.rss", true);
		SetPersonX("ss"+i, -100);
		SetPersonLayer("ss"+i, blood_layer);
		spark[i].id1 = GetPersonID("ss"+i);
		spark[i].x = -100;
		spark[i].y = 0;
		
		spark[i].vx = 0;
		spark[i].vy = 0;
		spark[i].type = 0;
		spark[i].frame = 0;
		spark[i].dir = 0;
	}	

	for (i=0;i<max_blood;i++)
	{
		CreatePerson("bs"+i, "blood_splat.rss", true);
		SetPersonX("bs"+i, -100);
		SetPersonLayer("bs"+i, blood_splat_layer);
		blood[i].id1 = GetPersonID("bs"+i);
		blood[i].x = -100;
		blood[i].y = 0;
		
		blood[i].vx = 0;
		blood[i].vy = 0;
		blood[i].type = 0;
		blood[i].frame = 0;
		blood[i].dir = 0;
	}

  for (i=0;i<max_casings;i++)
  {
		CreatePerson("c"+i, grs+"shells.rss", true);
		SetPersonX("c"+i, -100);
		SetPersonLayer("c"+i, gut_layer+1);
    IgnorePersonObstructions("c"+i, true);
	}

  for (i=0;i<max_shrapnel;i++)
  {
		CreatePerson("shrapnel"+i, "shrapnel.rss", true);
		SetPersonX("shrapnel"+i, -100);
		SetPersonLayer("shrapnel"+i, blood_layer);
	}

	//load entity info
	//setup entity info
	//setup main character info

  CreatePerson("main_sword2blade1", grs+"sword_swing1.rss", true);
  CreatePerson("main_gun2", grs+"gun2.rss", true);
  CreatePerson("main_torso", grs+"liegh_gun1.rss", true);
  CreatePerson("main_gun3", grs+"liegh_type2.rss", true);
  CreatePerson("main_gun4", grs+"liegh_type4.rss", true);
  CreatePerson("main_gun5", grs+"liegh_type5.rss", true);
  CreatePerson("main_gun6", grs+"liegh_type3.rss", true);
  CreatePerson("main_gun7", grs+"liegh_type6.rss", true);
  CreatePerson("main_gun8", grs+"liegh_type7.rss", true);
  CreatePerson("main_gun7b", grs+"liegh_type7b.rss", true);
  CreatePerson("main_sword2", grs+"liegh_sword2.rss", true);
  CreatePerson("main_legs", grs+"liegh_legs.rss", true);
	SetPersonLayer("main_sword2blade1", blood_layer);


	IgnorePersonObstructions("main_legs", true);
	IgnorePersonObstructions("main_torso", true);

	if (g_current_level == 17)
		g_stage_load = -1;

	if (g_stage_load == -1)
	{
		entities[0].x = GetPersonX("main_legs");
		entities[0].y = GetPersonY("main_legs")-8+4;
	}
	else if (g_stage_load == 0)
	{
		if (g_current_level == 9)
		{
			entities[0].x = 398*16+8;
			entities[0].y = 62*16+8-8+4;
		}
		else if (g_current_level == 16)
		{
			entities[0].x = 15*16;
			entities[0].y = 228*16+8-8+4;
		}
	}
	else if (g_stage_load == 1)
	{
		if (g_current_level == 9)
		{
			entities[0].x = 144*16+8;
			entities[0].y = 106*16+8-8+4;
		}
	}
	else if (g_stage_load == 2)
	{
		if (g_current_level == 9)
		{
			entities[0].x = 382*16+8;
			entities[0].y = 144*16+8-8+4;
		}
	}

	if (entities[0].x == 0 && entities[0].y == 0)
	{
		//just in case.
		entities[0].x = GetPersonX("main_legs");
		entities[0].y = GetPersonY("main_legs")-8+4;
	}

	
	SetPersonLayer("main_legs", blood_layer);
	SetPersonLayer("main_torso", blood_layer);

	entities[0].vx = 0;
	entities[0].vy = 0;
	entities[0].dir = 1;
	entities[0].dir1 = "aim1";
	entities[0].dir2 = 1;
	if (level == 5 || level == 6||level==10)
		entities[0].dir = -1;

	entities[0].frame1 = 1;
	entities[0].frame2 = 1;
	entities[0].invince = 0;
	entities[0].layer = blood_layer;

	entities[0].hp = max_hp*1.5;
	entities[0].maxhp = max_hp*1.5;
	entities[0].name = "main_torso";
	entities[0].spriteset = "leigh";
	entities[0].type = 0;
	CreatePerson(entities[0].name+"head", grs+"head.rss", true);

	if (level == undefined || level == 1)
		cur_weap = 0;
	e_count = 1;
	
	//go through the enemies and
	//set up the sprites

	for (i=0;i<max_heads;i++)
	{
		heads[i].id1 = -1;
	}

	var list = GetPersonList();
	
	for (i=0;i<list.length;i++)
	{
	  entities[e_count].type = -1;
	  entities[e_count].target = undefined;
		entities[e_count].nohit = false;
		if (list[i].substr(0, 6)=="enemy1" ||list[i].substr(0, 6)=="enemy2")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			entities[e_count].layer = blood_layer;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "aim1";
			entities[e_count].dir2 = "walk";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;
			entities[e_count].sight = 0;

			entities[e_count].w = 5+Math.floor(2*Math.random());
			entities[e_count].h = 14;
		
			entities[e_count].maxhp = max_hp;
			entities[e_count].hp = max_hp;
			entities[e_count].hp1 = max_hp/2;//arm1
			entities[e_count].hp2 = max_hp/2;//arm2
			entities[e_count].hp3 = max_hp;//legs

			entities[e_count].farm = Math.floor(Math.random()*2+1);
			entities[e_count].name = list[i];
			entities[e_count].type = 1;
			
			if (list[i].substr(0, 6)=="enemy1")
			{
				entities[e_count].spriteset = "enemy1";
				entities[e_count].type = 1;
				entities[e_count].sight = 1;
			//create limbs;
				DestroyPerson(list[i]);
	//			CreatePerson(list[i]+"head", "enemy1_head.rss", true)
				CreatePerson(list[i]+"arm2", grs+"enemy1_arm2.rss", true);
				CreatePerson(list[i]+"arm1", grs+"enemy1_arm1.rss", true);
				CreatePerson(list[i], grs+"enemy1_legs.rss", true);

				CreatePerson(list[i]+"head", grs+"head.rss", true);
	
				IgnorePersonObstructions(list[i]+"arm1", true);
				IgnorePersonObstructions(list[i]+"arm2", true);
				IgnorePersonObstructions(list[i], true);
				IgnorePersonObstructions(list[i]+"head", true);

			}
			else
			{
				entities[e_count].hp = max_hp*1.5;
				entities[e_count].hp1 = max_hp*0.75;//arm1
				entities[e_count].hp2 = max_hp*0.75;//arm2
				entities[e_count].hp3 = max_hp*1.5;//legs

				entities[e_count].maxhp1 = max_hp/2;//arm1
				entities[e_count].maxhp2 = max_hp/2;//arm2
				entities[e_count].maxhp3 = max_hp;//legs



				entities[e_count].spriteset = "enemy2";
				entities[e_count].type = 3;
			//create limbs;
				DestroyPerson(list[i]);
	//			CreatePerson(list[i]+"head", "enemy1_head.rss", true)
				CreatePerson(list[i]+"arm2", grs+"enemy2_arm2.rss", true);
				CreatePerson(list[i]+"arm1", grs+"enemy2_arm1.rss", true);
				CreatePerson(list[i], grs+"enemy2_legs.rss", true);
				
				CreatePerson(list[i]+"head", grs+"head.rss", true);
	
				IgnorePersonObstructions(list[i]+"arm1", true);
				IgnorePersonObstructions(list[i]+"arm2", true);
				IgnorePersonObstructions(list[i], true);
				IgnorePersonObstructions(list[i]+"head", true);
			}
			
			var colory = CreateColor(255,128, 128, 255);
			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			heads[e_count].id1 = 0;

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
//			CreatePerson(list[i]+"legs", "enemy1_legs.rss", true)
			
			SetPersonX(list[i]+"arm1", entities[e_count].x);
			SetPersonY(list[i]+"arm1", entities[e_count].y);
			SetPersonX(list[i]+"arm2", entities[e_count].x);
			SetPersonY(list[i]+"arm2", entities[e_count].y);

			SetPersonLayer(list[i]+"arm1", entities[e_count].layer);
			SetPersonLayer(list[i]+"arm2", entities[e_count].layer);
			
			SetPersonDirection(list[i], "legattack1east");
			SetPersonDirection(list[i]+"arm1", "legattack1east");
			SetPersonDirection(list[i]+"arm2", "legattack1east");
			SetPersonFrame(list[i], 0);
			SetPersonFrame(list[i]+"arm1", 0);
			SetPersonFrame(list[i]+"arm2", 0);
			
			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs
			

			if (list[i].charAt(list[i].length-1) == 'a')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
			}
			else
			  entities[e_count].ambush = false;


//			SetPersonX(list[i]+"legs", entities[e_count].x);
//			SetPersonY(list[i]+"legs", entities[e_count].y);
//			SetPersonX(list[i]+"head", entities[e_count].x);
//			SetPersonY(list[i]+"head", entities[e_count].y);

		
			e_count++;
		}
		else if (list[i].substr(0, 6)=="mantis")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+10;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			entities[e_count].layer = blood_layer;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "rise";
			entities[e_count].dir2 = "rise";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;
			entities[e_count].sight = 3;

			entities[e_count].w = 6+Math.floor(2*Math.random());
			entities[e_count].h = 14;
		
			entities[e_count].maxhp = 2*max_hp;
			entities[e_count].hp = 2*max_hp;
			entities[e_count].hp1 = 1.5*max_hp;//arm1
			entities[e_count].hp2 = 1.5*max_hp;//arm2
			entities[e_count].hp3 = 2*max_hp;//legs
			entities[e_count].farm = Math.floor(Math.random()*2+1);
			entities[e_count].name = list[i];
			entities[e_count].type = 7;
			
			entities[e_count].spriteset = "mantis";
			entities[e_count].sight = 1;
			//create limbs;
				DestroyPerson(list[i]);
	//			CreatePerson(list[i]+"head", "enemy1_head.rss", true)
				CreatePerson(list[i]+"arm2", grs+"mantis_arm2.rss", true);
				CreatePerson(list[i]+"arm1", grs+"mantis_arm1.rss", true);
				CreatePerson(list[i], grs+"mantis_legs.rss", true);

				CreatePerson(list[i]+"head", grs+"head.rss", true);
	
				IgnorePersonObstructions(list[i]+"arm1", true);
				IgnorePersonObstructions(list[i]+"arm2", true);
				IgnorePersonObstructions(list[i], true);
				IgnorePersonObstructions(list[i]+"head", true);

			var colory = CreateColor(255,128, 128, 255);
			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			heads[e_count].id1 = 0;

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
//			CreatePerson(list[i]+"legs", "enemy1_legs.rss", true)
			
			SetPersonX(list[i]+"arm1", entities[e_count].x);
			SetPersonY(list[i]+"arm1", entities[e_count].y);
			SetPersonX(list[i]+"arm2", entities[e_count].x);
			SetPersonY(list[i]+"arm2", entities[e_count].y);

			SetPersonLayer(list[i]+"arm1", entities[e_count].layer);
			SetPersonLayer(list[i]+"arm2", entities[e_count].layer);
			
			SetPersonDirection(list[i], "attack1east");
			SetPersonDirection(list[i]+"arm1", "attack1east");
			SetPersonDirection(list[i]+"arm2", "attack1east");
			SetPersonFrame(list[i], 0);
			SetPersonFrame(list[i]+"arm1", 0);
			SetPersonFrame(list[i]+"arm2", 0);
			
			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs


			if (list[i].charAt(list[i].length-1) == 'a')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
				entities[e_count].sight = 3;
			}
			else if (list[i].charAt(list[i].length-1) == 'b')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
				entities[e_count].sight = 2;
			}
			else
			  entities[e_count].ambush = false;


//			SetPersonX(list[i]+"legs", entities[e_count].x);
//			SetPersonY(list[i]+"legs", entities[e_count].y);
//			SetPersonX(list[i]+"head", entities[e_count].x);
//			SetPersonY(list[i]+"head", entities[e_count].y);
		
			e_count++;
		}
		else if (list[i].substr(0, 4)=="eye1")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			entities[e_count].layer = blood_layer;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "aim1";
			entities[e_count].dir2 = "idle";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;
			entities[e_count].sight = 0;

			entities[e_count].w = 5+Math.floor(2*Math.random());
			entities[e_count].h = 14;
		
			entities[e_count].maxhp = max_hp;
			entities[e_count].hp = max_hp*4;
			entities[e_count].hp1 = max_hp*1.5;//arm1
			entities[e_count].hp2 = max_hp*1.5;//arm2
			entities[e_count].hp3 = max_hp*3;//legs
			entities[e_count].farm = Math.floor(Math.random()*2+1);
			entities[e_count].name = list[i];
			entities[e_count].type = 5;
			

			entities[e_count].spriteset = "eye1";
			//create limbs;
			DestroyPerson(list[i]);
			CreatePerson(list[i]+"arm2", grs+"eye1_arm2.rss", true);
			CreatePerson(list[i]+"arm1", grs+"eye1_arm1.rss", true);
			CreatePerson(list[i], grs+"eye1_legs.rss", true);

			CreatePerson(list[i]+"head", grs+"head.rss", true);

			IgnorePersonObstructions(list[i]+"arm1", true);
			IgnorePersonObstructions(list[i]+"arm2", true);
			IgnorePersonObstructions(list[i], true);
			IgnorePersonObstructions(list[i]+"head", true);

			
			var colory = CreateColor(255,128, 128, 255);
			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			heads[e_count].id1 = 0;

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
//			CreatePerson(list[i]+"legs", "enemy1_legs.rss", true)
			
			SetPersonX(list[i]+"arm1", entities[e_count].x);
			SetPersonY(list[i]+"arm1", entities[e_count].y);
			SetPersonX(list[i]+"arm2", entities[e_count].x);
			SetPersonY(list[i]+"arm2", entities[e_count].y);

			SetPersonLayer(list[i]+"arm1", entities[e_count].layer);
			SetPersonLayer(list[i]+"arm2", entities[e_count].layer);
			
			SetPersonDirection(list[i], "legattack1east");
			SetPersonDirection(list[i]+"arm1", "legattack1east");
			SetPersonDirection(list[i]+"arm2", "legattack1east");
			SetPersonFrame(list[i], 0);
			SetPersonFrame(list[i]+"arm1", 0);
			SetPersonFrame(list[i]+"arm2", 0);
			
			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs

			if (list[i].charAt(list[i].length-1) == 'a')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
			}
			else
			  entities[e_count].ambush = false;


//			SetPersonX(list[i]+"legs", entities[e_count].x);
//			SetPersonY(list[i]+"legs", entities[e_count].y);
//			SetPersonX(list[i]+"head", entities[e_count].x);
//			SetPersonY(list[i]+"head", entities[e_count].y);
		
			e_count++;
		}
		else if (list[i].substr(0, 5)=="umber")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			entities[e_count].layer = blood_layer;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "aim1";
			entities[e_count].dir2 = "idle";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;
			entities[e_count].sight = 0;

			entities[e_count].w = 13+Math.floor(2*Math.random());
			entities[e_count].h = 14;
		
			entities[e_count].maxhp = max_hp*g_umber_hp;
			entities[e_count].hp = max_hp*g_umber_hp;
			entities[e_count].hp1 = max_hp*1.5;//arm1
			entities[e_count].hp2 = max_hp*1.5;//arm2
			entities[e_count].hp3 = max_hp*3;//legs
			entities[e_count].farm = Math.floor(Math.random()*2+1);
			entities[e_count].name = list[i];
			entities[e_count].type = 9;
			

			entities[e_count].spriteset = "eye1";
			//create limbs;
			DestroyPerson(list[i]);
			CreatePerson(list[i], grs+"umberdog.rss", true);

//			CreatePerson(list[i]+"head", "head.rss", true);

			IgnorePersonObstructions(list[i], true);
//			IgnorePersonObstructions(list[i]+"head", true);

			
			var colory = CreateColor(255,128, 128, 255);
			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			heads[e_count].id1 = 0;

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
//			CreatePerson(list[i]+"legs", "enemy1_legs.rss", true)
	
			SetPersonDirection(list[i], "attack1east");
			SetPersonFrame(list[i], 0);
			
			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs

			if (list[i].charAt(list[i].length-1) == 'a')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
			}
			else
			  entities[e_count].ambush = false;


//			SetPersonX(list[i]+"legs", entities[e_count].x);
//			SetPersonY(list[i]+"legs", entities[e_count].y);
//			SetPersonX(list[i]+"head", entities[e_count].x);
//			SetPersonY(list[i]+"head", entities[e_count].y);
		
			e_count++;
		}
		else if (list[i].substr(0, 5)=="guard")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])-8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			entities[e_count].layer = blood_layer;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "aim1";
			entities[e_count].dir2 = "idle";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;
			entities[e_count].sight = 1;

			entities[e_count].w = 12+Math.floor(2*Math.random());
			entities[e_count].h = 14;
		
			entities[e_count].maxhp = max_hp*g_guard_hp;
			entities[e_count].hp = max_hp*g_guard_hp;
			entities[e_count].hp1 = max_hp*1.5;//arm1
			entities[e_count].hp2 = max_hp*1.5;//arm2
			entities[e_count].hp3 = max_hp*3;//legs
			entities[e_count].farm = Math.floor(Math.random()*2+1);
			entities[e_count].name = list[i];
			entities[e_count].type = 12;
			

			entities[e_count].spriteset = "guard";
			//create limbs;
			DestroyPerson(list[i]);
			CreatePerson(list[i], grs+"guard_legs.rss", true);

			CreatePerson(list[i]+"head", grs+"head.rss", true);

			IgnorePersonObstructions(list[i], true);
			IgnorePersonObstructions(list[i]+"head", true);

			
			var colory = CreateColor(255,128, 128, 255);
			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			heads[e_count].id1 = GetPersonID(list[i]+"head");

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
//			CreatePerson(list[i]+"legs", "enemy1_legs.rss", true)
	
			SetPersonDirection(list[i], "attack1east");
			SetPersonFrame(list[i], 0);
			
			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs

			if (list[i].charAt(list[i].length-1) == 'a')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
			}
			else
			  entities[e_count].ambush = false;


//			SetPersonX(list[i]+"legs", entities[e_count].x);
//			SetPersonY(list[i]+"legs", entities[e_count].y);
//			SetPersonX(list[i]+"head", entities[e_count].x);
//			SetPersonY(list[i]+"head", entities[e_count].y);
		
			e_count++;
		}
		else if (list[i].substr(0, 5)=="jelly")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			entities[e_count].layer = blood_layer;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "aim1";
			entities[e_count].dir2 = "idle";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;
			entities[e_count].sight = 0;
			entities[e_count].wantup = 0;
			entities[e_count].attackcount = 0;

			entities[e_count].w = 4+Math.floor(3*Math.random());
			entities[e_count].h = 14;
		
			entities[e_count].maxhp = max_hp*g_umber_hp;
			entities[e_count].hp = max_hp*2;
			entities[e_count].hp1 = max_hp*1.5;//arm1
			entities[e_count].hp2 = max_hp*1.5;//arm2
			entities[e_count].hp3 = max_hp*3;//legs
			entities[e_count].farm = Math.floor(Math.random()*2+1);
			entities[e_count].name = list[i];
			entities[e_count].type = 10;
			

			entities[e_count].spriteset = "jellyfish1";
			//create limbs;
			DestroyPerson(list[i]);
			CreatePerson(list[i], grs+"jellyfish1_legs.rss", true);

//			CreatePerson(list[i]+"head", "head.rss", true);

			IgnorePersonObstructions(list[i], true);
//			IgnorePersonObstructions(list[i]+"head", true);

			
			var colory = CreateColor(255,128, 128, 255);
			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			heads[e_count].id1 = 0;

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
//			CreatePerson(list[i]+"legs", "enemy1_legs.rss", true)
	
			SetPersonDirection(list[i], "attack1east");
			SetPersonFrame(list[i], 0);

			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs
			

			if (list[i].charAt(list[i].length-1) == 'a')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
			}
			else
			  entities[e_count].ambush = false;


//			SetPersonX(list[i]+"legs", entities[e_count].x);
//			SetPersonY(list[i]+"legs", entities[e_count].y);
//			SetPersonX(list[i]+"head", entities[e_count].x);
//			SetPersonY(list[i]+"head", entities[e_count].y);
		
			e_count++;
		}
		else if (list[i].substr(0, 6)=="drone1")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			entities[e_count].layer = blood_layer;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "aim1";
			entities[e_count].dir2 = "idle";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;
			entities[e_count].sight = 0;
			entities[e_count].wantup = 0;
			entities[e_count].attackcount = 0;

			entities[e_count].w = 4+Math.floor(3*Math.random());
			entities[e_count].h = 14;
		
			entities[e_count].maxhp = max_hp;
			entities[e_count].hp = max_hp*4;
			entities[e_count].hp1 = max_hp*1.5;//arm1
			entities[e_count].hp2 = max_hp*1.5;//arm2
			entities[e_count].hp3 = max_hp*3;//legs
			entities[e_count].farm = 2;
			entities[e_count].name = list[i];
			entities[e_count].type = 8;
			

			entities[e_count].spriteset = "drone1";
			//create limbs;
			DestroyPerson(list[i]);
			CreatePerson(list[i]+"arm1", grs+"drone1_arms.rss", true);
			CreatePerson(list[i], grs+"drone1_legs.rss", true);

			CreatePerson(list[i]+"head", grs+"head.rss", true);

			IgnorePersonObstructions(list[i]+"arm1", true);
			IgnorePersonObstructions(list[i], true);
			IgnorePersonObstructions(list[i]+"head", true);

			
			var colory = CreateColor(255,128, 128, 255);
			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			heads[e_count].id1 = 0;

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
//			CreatePerson(list[i]+"legs", "enemy1_legs.rss", true)
			
			SetPersonX(list[i]+"arm1", entities[e_count].x);
			SetPersonY(list[i]+"arm1", entities[e_count].y);

			SetPersonLayer(list[i]+"arm1", entities[e_count].layer);
			
			SetPersonDirection(list[i], "attack1east");
			SetPersonDirection(list[i]+"arm1", "attack1east");
			SetPersonFrame(list[i], 0);
			SetPersonFrame(list[i]+"arm1", 0);
			
			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs

			if (list[i].charAt(list[i].length-1) == 'a')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
			}
			else
			  entities[e_count].ambush = false;

			entities[e_count].avx = 0;
			entities[e_count].avy = 0;

			entities[e_count].stop = false;
			entities[e_count].nohit = false;

			if (list[i].charAt(list[i].length-1) == 'u')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
				entities[e_count].avx = 0;
				entities[e_count].avy = 1;
			}
			else if (list[i].charAt(list[i].length-1) == 'd')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
				entities[e_count].avx = 0;
				entities[e_count].avy = -1;
			}
			else if (list[i].charAt(list[i].length-1) == 'l')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
				entities[e_count].avx = -1;
				entities[e_count].avy = 0;
			}
			else if (list[i].charAt(list[i].length-1) == 'r')
			{
				entities[e_count].hp = 0;
			  entities[e_count].ambush = true;
				entities[e_count].avx = 1;
				entities[e_count].avy = 0;
			}



//			SetPersonX(list[i]+"legs", entities[e_count].x);
//			SetPersonY(list[i]+"legs", entities[e_count].y);
//			SetPersonX(list[i]+"head", entities[e_count].x);
//			SetPersonY(list[i]+"head", entities[e_count].y);
		
			e_count++;
		}
		else if (list[i].substr(0, 7)=="barrel1")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+15+7;
			entities[e_count].layer = blood_layer-1;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "aim1";
			entities[e_count].dir2 = "idle";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 0;

			entities[e_count].w = 12;
			entities[e_count].h = 18;
		
			entities[e_count].maxhp = 3;
			entities[e_count].hp = 3;
			entities[e_count].hp1 = 3;//arm1
			entities[e_count].hp2 = 3;//arm2
			entities[e_count].hp3 = 3;//legs
			entities[e_count].farm = 0;
			entities[e_count].name = list[i];
			entities[e_count].spriteset = "barrel1";
			entities[e_count].type = 2;
			
		//create limbs;
//			DestroyPerson(list[i]);
      IgnorePersonObstructions(list[i], true);
			
//			var colory = CreateColor(255,128, 128, 255);
//			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
			SetPersonFrame(list[i], 0);
			
		
			e_count++;
		}
		else if (list[i].substr(0, 5)=="heart")
		{
			entities[e_count].x = GetPersonX(list[i])+24;
			entities[e_count].y = GetPersonY(list[i])+32;
			entities[e_count].layer = blood_layer-1;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "idle";
			entities[e_count].dir2 = "idle";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;

			if (list[i].charAt(list[i].length-1) == 'g')
			{
				entities[e_count].target = "door5_16c";
			}
			else if (list[i].charAt(list[i].length-1) == 'h')
			{
				entities[e_count].target = "door5_17c";
			}

			entities[e_count].w = 24;
			entities[e_count].h = 34;
		
			entities[e_count].maxhp = 250;
			entities[e_count].hp = 250;
			entities[e_count].hp1 = 250;//arm1
			entities[e_count].hp2 = 250;//arm2
			entities[e_count].hp3 = 250;//legs
			entities[e_count].farm = 0;
			entities[e_count].name = list[i];
			entities[e_count].spriteset = "heart";
			entities[e_count].type = 11;
			
		//create limbs;
//			DestroyPerson(list[i]);
      IgnorePersonObstructions(list[i], true);
			
//			var colory = CreateColor(255,128, 128, 255);
//			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
			SetPersonFrame(list[i], 0);
			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs
					
			e_count++;
		}
		else if (list[i].substr(0, 4)=="wipe")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+14;
			entities[e_count].layer = blood_layer-1;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = 1;
			entities[e_count].dir1 = "fadein";
			entities[e_count].frame1 = 1;

			entities[e_count].w = 16;
			entities[e_count].h = 16;
		
			entities[e_count].maxhp = 50;
			entities[e_count].hp = 50;//main head
			entities[e_count].hp1 = wipe_hp1_max;//injury type
			entities[e_count].hp2 = 10;//injury type
			entities[e_count].hp3 = 10;//injury type
			entities[e_count].farm = 1;
			entities[e_count].name = list[i];
			entities[e_count].spriteset = "wipe";
			entities[e_count].type = 4;//wipe type
			
		//create limbs;
//			DestroyPerson(list[i]);
      IgnorePersonObstructions(list[i], true);
			
//			var colory = CreateColor(255,128, 128, 255);
//			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
			SetPersonFrame(list[i], 0);
			
			CreatePerson(entities[e_count].name+"star1", grs+"guts1.rss", true)
			CreatePerson(entities[e_count].name+"star2", grs+"guts1.rss", true)
			CreatePerson(entities[e_count].name+"star3", grs+"guts1.rss", true)
			
			SetPersonX(entities[e_count].name+"star1", -200);
			SetPersonX(entities[e_count].name+"star2", -200);
			SetPersonX(entities[e_count].name+"star3", -200);
			SetPersonLayer(entities[e_count].name+"star1", entities[e_count].layer);
			SetPersonLayer(entities[e_count].name+"star2", entities[e_count].layer);
			SetPersonLayer(entities[e_count].name+"star3", entities[e_count].layer);

			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs
			
			e_count++;
		}
		else if (list[i].substr(0,10) == "head_shred")
		{
			CreatePerson(list[i]+"head", grs+"head.rss", true);
			entities[e_count].name = list[i];
			heads[e_count].active = true;
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+8;
			heads[e_count].id1 = 0;
			DestroyPerson(list[i]);
			IgnorePersonObstructions(list[i]+"head", true);

			e_count++;
		}
		else if (list[i].substr(0, 2)=="id")
		{
			entities[e_count].x = GetPersonX(list[i]);
			entities[e_count].y = GetPersonY(list[i])+4;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			entities[e_count].layer = blood_layer;

			entities[e_count].vx = 0;
			entities[e_count].vy = 0;
			entities[e_count].dir = -1;
			entities[e_count].dir1 = "aim1";
			entities[e_count].dir2 = "idle";
			entities[e_count].frame1 = 1;
			entities[e_count].frame2 = 1;
			entities[e_count].sight = 0;

			entities[e_count].w = 4+Math.floor(3*Math.random());
			entities[e_count].h = 24;
		
			entities[e_count].maxhp = idarm_hp;
			entities[e_count].hp = idarm_hp;
			entities[e_count].hp1 = idarm_hp;//arm1(primary)
			entities[e_count].hp2 = idarm_hp;//arm2
			entities[e_count].hp3 = idarm_hp;//legs
			entities[e_count].farm = 1;
			entities[e_count].name = list[i];
			entities[e_count].type = 6;
			

			entities[e_count].spriteset = "id";
			//create limbs;
			DestroyPerson(list[i]);
			CreatePerson(list[i]+"arm1", grs+"id_arm1.rss", true);
			CreatePerson(list[i], grs+"id_legs.rss", true);

			CreatePerson(list[i]+"head", grs+"head.rss", true);

			IgnorePersonObstructions(list[i]+"arm1", true);
			IgnorePersonObstructions(list[i], true);
			IgnorePersonObstructions(list[i]+"head", true);

			
			var colory = CreateColor(255,128, 128, 255);
			entities[e_count].mask = colory;
//      SetPersonMask(list[i]+"arm1", colory);
//      SetPersonMask(list[i]+"arm2", colory);
  //    SetPersonMask(list[i], colory);
    //  SetPersonMask(list[i]+"head", colory);

			heads[e_count].id1 = 0;

			SetPersonX(list[i], entities[e_count].x);
			SetPersonY(list[i], entities[e_count].y);
			SetPersonLayer(list[i], entities[e_count].layer);
			
//			CreatePerson(list[i]+"legs", "enemy1_legs.rss", true)
			
			SetPersonX(list[i]+"arm1", entities[e_count].x);
			SetPersonY(list[i]+"arm1", entities[e_count].y);

			SetPersonLayer(list[i]+"arm1", entities[e_count].layer);
			
			SetPersonDirection(list[i], "attack1east");
			SetPersonDirection(list[i]+"arm1", "attack1east");
			SetPersonFrame(list[i], 0);
			SetPersonFrame(list[i]+"arm1", 0);

//			var facedir = 1;
			SetPersonIDHorizontalFlip(GetPersonID(list[i]), 1);
			SetPersonIDHorizontalFlip(GetPersonID(list[i]+"arm1"), 1);

			entities[e_count].maxhp = entities[e_count].hp;
			entities[e_count].maxhp1 = entities[e_count].hp1;//arm1
			entities[e_count].maxhp2 = entities[e_count].hp2;//arm2
			entities[e_count].maxhp3 = entities[e_count].hp3;//legs


			e_count++;
		}


		else if (list[i].substr(0,11) == "blood_splat")
		{
			for (l=0;l<max_trails;l++)
			{
				SpawnBlood(GetPersonX(list[i]),GetPersonY(list[i]), 20*Math.random()-10, -6*Math.random()-5, 3);
				
			}
			SetPersonX(list[i], -200);
		}

	}

	var listy = GetPersonList();
	var tgx,tgy;

	for (i=0;i<listy.length;i++)
	{
		if (listy[i].substr(0, 6)=="barrel")
		{
			tgx = GetPersonX(listy[i]);
			tgy = GetPersonY(listy[i]);
			DestroyPerson(listy[i]);
			
			CreatePerson(listy[i], grs+"barrel1.rss", true);
	
			SetPersonX(listy[i], tgx);
			SetPersonY(listy[i], tgy);
		}
	}

	for (i=0;i<listy.length;i++)
	{
		if (listy[i].substr(0, 6)=="locker")
		{
			tgx = GetPersonX(listy[i]);
			tgy = GetPersonY(listy[i]);
			DestroyPerson(listy[i]);
			
			if (listy[i].substr(0, 7) == "locker2")	
				CreatePerson(listy[i], grs+"locker2.rss", true);
			else if (listy[i].substr(0, 7) == "locker3")	
				CreatePerson(listy[i], grs+"locker3.rss", true);
			else
				CreatePerson(listy[i], grs+"locker1.rss", true);
	
			SetPersonX(listy[i], tgx);
			SetPersonY(listy[i], tgy);
		}
		if (listy[i].substr(0, 6)=="door1b")
		{
			tgx = GetPersonX(listy[i]);
			tgy = GetPersonY(listy[i]);
			DestroyPerson(listy[i]);
			
			CreatePerson(listy[i], grs+"door1b.rss", true);
			SetPersonX(listy[i], tgx);
			SetPersonY(listy[i], tgy);
		}
		else if (listy[i].substr(0, 5)=="door1")
		{
			tgx = GetPersonX(listy[i]);
			tgy = GetPersonY(listy[i]);
			DestroyPerson(listy[i]);
			
			CreatePerson(listy[i], grs+"door1.rss", true);
			SetPersonX(listy[i], tgx);
			SetPersonY(listy[i], tgy);
		}
		if (listy[i].substr(0, 5)=="door2")
		{
			tgx = GetPersonX(listy[i]);
			tgy = GetPersonY(listy[i]);
			DestroyPerson(listy[i]);
			
			CreatePerson(listy[i], grs+"door2.rss", true);
			SetPersonX(listy[i], tgx);
			SetPersonY(listy[i], tgy);
		}
		if (listy[i].substr(0, 5)=="door3")
		{
			tgx = GetPersonX(listy[i]);
			tgy = GetPersonY(listy[i]);
			DestroyPerson(listy[i]);
			
			CreatePerson(listy[i], grs+"door3.rss", true);
			SetPersonX(listy[i], tgx);
			SetPersonY(listy[i], tgy);
		}
		if (listy[i].substr(0, 5)=="door4")
		{
			tgx = GetPersonX(listy[i]);
			tgy = GetPersonY(listy[i]);
			DestroyPerson(listy[i]);
			
			CreatePerson(listy[i], grs+"door4.rss", true);
			SetPersonX(listy[i], tgx);
			SetPersonY(listy[i], tgy);
		}
		if (listy[i].substr(0, 5)=="door5")
		{
			tgx = GetPersonX(listy[i])+8;
			tgy = GetPersonY(listy[i]);
			DestroyPerson(listy[i]);
			
			CreatePerson(listy[i], grs+"door5.rss", true);
			SetPersonX(listy[i], tgx);
			SetPersonY(listy[i], tgy);
		}
	
	}

	var d_count = 0;

	var gtdx;
	var gtdy;

	
	for (i=0;i<list.length;i++)
	{
		if (list[i].substr(0, 4)=="door")
		{
			doors[d_count].x = GetPersonX(list[i]);
			doors[d_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			doors[d_count].layer = blood_layer;

			doors[d_count].dir = "closed1";
			doors[d_count].frame = 0;

			doors[d_count].w = 32;
			doors[d_count].h = 14;
			doors[d_count].type = 1;//regular door
			doors[d_count].hp = 0;
			
			if (list[i].charAt(list[i].length-1) == 'c')
			  doors[d_count].type = 3;
			else if (list[i].charAt(list[i].length-1) == 'd')
			{
			  doors[d_count].hp = 5;
			  doors[d_count].type = 4;
			}
			else if (list[i].charAt(list[i].length-1) == 'j')
			{
			  doors[d_count].hp = 20;
			  doors[d_count].type = 4;			
			  doors[d_count].dir = "closed2";
			}
		

			//some doors can be opened with explosions

			doors[d_count].name = list[i];
			if (list[i].substr(0, 6)=="door1b")
				doors[d_count].spriteset = "door1b";
			else if (list[i].substr(0, 5)=="door1")
				doors[d_count].spriteset = "door1";
			else if (list[i].substr(0, 5)=="door2")
				doors[d_count].spriteset = "door2";
			else if (list[i].substr(0, 5)=="door3")
				doors[d_count].spriteset = "door3";
			else if (list[i].substr(0, 5)=="door4")
				doors[d_count].spriteset = "door4";
			else if (list[i].substr(0, 5)=="door5")
				doors[d_count].spriteset = "door5";
			
      IgnorePersonObstructions(list[i], true);
			
			SetPersonX(list[i], doors[d_count].x);
			SetPersonY(list[i], doors[d_count].y);
			SetPersonLayer(list[i], doors[d_count].layer);
			
			SetPersonFrame(list[i], 0);
			SetPersonDirection(list[i], doors[d_count].dir);


			if (list[i].charAt(list[i].length-1)=="o")
			{
				gtdx = Math.floor(doors[d_count].x/GetTileWidth());
				gtdy = Math.floor(doors[d_count].y/GetTileWidth());
					
				SetTile(gtdx,gtdy, 0, 0);
				SetTile(gtdx,gtdy+1, 0, 0);

				doors[d_count].dir = "open1";
				doors[d_count].frame=0;
				doors[d_count].active=1;

				SetPersonDirection(doors[d_count].name, doors[d_count].dir);
				SetPersonFrame(doors[d_count].name, doors[d_count].frame);
			}
	
			d_count++;
		}
		else if (list[i].substr(0, 6)=="switch")
		{
			doors[d_count].x = GetPersonX(list[i]);
			doors[d_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			doors[d_count].layer = blood_layer-1;

			doors[d_count].dir = "off1";
			doors[d_count].frame = 0;

			doors[d_count].w = 16;
			doors[d_count].h = 16;
		

			//some doors can be opened with explosions
			doors[d_count].hp = 0;

			doors[d_count].name = list[i];
			doors[d_count].spriteset = "switch1";
			doors[d_count].type = 2;//switch door
			
      IgnorePersonObstructions(list[i], true);
			
			SetPersonX(list[i], doors[d_count].x);
			SetPersonY(list[i], doors[d_count].y);
			SetPersonLayer(list[i], doors[d_count].layer);
			
			SetPersonFrame(list[i], 0);
			SetPersonDirection(list[i], doors[d_count].dir);

			if (list[i].charAt(list[i].length-1)=="p")
			{
				doors[d_count].dir = "on1";
				doors[d_count].frame = 0;
				SetPersonDirection(doors[d_count].name, doors[d_count].dir);
				SetPersonFrame(doors[d_count].name, doors[d_count].frame);

				doors[d_count].active = 1;
			}

			
			d_count++;
		}
		else if (list[i].substr(0, 6)=="locker")
		{
			if (g_current_level == 11)
				doors[d_count].x = GetPersonX(list[i])+8;
			else
				doors[d_count].x = GetPersonX(list[i]);
			doors[d_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			doors[d_count].layer = blood_layer;

			doors[d_count].dir = "closed1";
			doors[d_count].frame = 0;

			doors[d_count].w = 16;
			doors[d_count].h = 16;
		

			//some doors can be opened with explosions
			doors[d_count].hp = 0;

			doors[d_count].name = list[i];
			if (list[i].substr(0,7) == "locker2")
				doors[d_count].spriteset = "locker2";
			else if (list[i].substr(0,7) == "locker3")
				doors[d_count].spriteset = "locker3";
			else
				doors[d_count].spriteset = "locker1";
			doors[d_count].type = 6;//locker
			
			var number = parseInt(list[i].substr(list[i].length-3, list[i].length));
			if (list[i].substr(list[i].length-3, list[i].length) == "009")
				doors[d_count].target = 9;
			else if (list[i].substr(list[i].length-3, list[i].length) == "010")
				doors[d_count].target = 10;
			else if (list[i].substr(list[i].length-3, list[i].length) == "011")
				doors[d_count].target = 11;
			else if (list[i].substr(list[i].length-3, list[i].length) == "012")
				doors[d_count].target = 12;
			else if (list[i].substr(list[i].length-3, list[i].length) == "013")
				doors[d_count].target = 13;
			else if (list[i].substr(list[i].length-3, list[i].length) == "014")
				doors[d_count].target = 14;
			else if (list[i].substr(list[i].length-3, list[i].length) == "015")
				doors[d_count].target = 15;
			else if (list[i].substr(list[i].length-3, list[i].length) == "016")
				doors[d_count].target = 16;
			else if (list[i].substr(list[i].length-3, list[i].length) == "017")
				doors[d_count].target = 17;
			else if (list[i].substr(list[i].length-3, list[i].length) == "018")
				doors[d_count].target = 18;
			else if (list[i].substr(list[i].length-3, list[i].length) == "019")
				doors[d_count].target = 19;
			else if (list[i].substr(list[i].length-3, list[i].length) == "020")
				doors[d_count].target = 20;
			else if (list[i].substr(list[i].length-3, list[i].length) == "021")
				doors[d_count].target = 21;
			else if (list[i].substr(list[i].length-3, list[i].length) == "022")
				doors[d_count].target = 22;
			else if (list[i].substr(list[i].length-3, list[i].length) == "023")
				doors[d_count].target = 23;
			else if (list[i].substr(list[i].length-3, list[i].length) == "024")
				doors[d_count].target = 24;
			else if (list[i].substr(list[i].length-3, list[i].length) == "025")
				doors[d_count].target = 25;
			else if (list[i].substr(list[i].length-3, list[i].length) == "026")
				doors[d_count].target = 26;
			else if (list[i].substr(list[i].length-3, list[i].length) == "027")
				doors[d_count].target = 27;
			else if (list[i].substr(list[i].length-3, list[i].length) == "028")
				doors[d_count].target = 28;
			else if (list[i].substr(list[i].length-3, list[i].length) == "029")
				doors[d_count].target = 29;
			else if (list[i].substr(list[i].length-3, list[i].length) == "030")
				doors[d_count].target = 30;
			else if (list[i].substr(list[i].length-3, list[i].length) == "031")
				doors[d_count].target = 31;
			else if (list[i].substr(list[i].length-3, list[i].length) == "032")
				doors[d_count].target = 32;
		  else
				doors[d_count].target = number;

      IgnorePersonObstructions(list[i], true);
			
			SetPersonX(list[i], doors[d_count].x);
			SetPersonY(list[i], doors[d_count].y);
			SetPersonLayer(list[i], doors[d_count].layer);
			
			SetPersonFrame(list[i], 0);
			SetPersonDirection(list[i], doors[d_count].dir);
			
			if (list[i].charAt(list[i].length-1)=="e")
			{
				doors[d_count].active = 1;
//				AccessLocker(doors[d_count].target);
//				PlaySound(40);
				
				doors[d_count].dir = "open1";
				doors[d_count].frame = 0;
				SetPersonDirection(doors[d_count].name, doors[d_count].dir);
				SetPersonFrame(doors[d_count].name, doors[d_count].frame);
			}

			d_count++;
		}
		else if (list[i].substr(0, 8)=="terminal")
		{
			doors[d_count].x = GetPersonX(list[i])+16;
			doors[d_count].y = GetPersonY(list[i])+8;
//			entities[e_count].layer = GetPersonLayer(list[i]);
			doors[d_count].layer = blood_layer-1;

			doors[d_count].dir = "terminal1";
			doors[d_count].frame = 0;

			doors[d_count].w = 16;
			doors[d_count].h = 16;
		
			doors[d_count].target = list[i].substr(10,list[i].length);

			//some doors can be opened with explosions
			doors[d_count].hp = 0;

			doors[d_count].name = list[i];
			doors[d_count].spriteset = "terminal1";
			doors[d_count].type = 5;//switch door
			
      IgnorePersonObstructions(list[i], true);
			
			SetPersonX(list[i], doors[d_count].x);
			SetPersonY(list[i], doors[d_count].y);
			SetPersonLayer(list[i], doors[d_count].layer);
			
			SetPersonFrame(list[i], 0);
			SetPersonDirection(list[i], doors[d_count].dir);
			
			d_count++;
		}
	
	
	}


  entities[0].id1 = GetPersonID("main_torso"); 
  entities[0].id2 = GetPersonID("main_legs"); 
  entities[0].id3 = GetPersonID("main_gun2"); 
  entities[0].id4 = GetPersonID("main_gun3"); 
  entities[0].id5 = GetPersonID("main_gun4"); 
  entities[0].id6 = GetPersonID("main_gun5"); 
  entities[0].id7 = GetPersonID("main_gun6"); 
  entities[0].id8 = GetPersonID("main_gun7"); 
  entities[0].id9 = GetPersonID("main_gun8"); 
  entities[0].id10 = GetPersonID("main_gun7b"); 
  entities[0].id11 = GetPersonID("main_sword2"); 
  entities[0].id12 = GetPersonID("main_sword2blade1"); 
	
	for (i=0;i<max_entities;i++)
	{
			entities[i].stop = false;
	    if (entities[i].type == 1||entities[i].type == 3||entities[i].type == 5)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name+"arm1");
			entities[i].id3 = GetPersonID(entities[i].name+"arm2");
			}
	    else if (entities[i].type == 2)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name);
			entities[i].id3 = GetPersonID(entities[i].name);
			}
	    else if (entities[i].type == 4)//wipe
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name);
			entities[i].id3 = GetPersonID(entities[i].name);
			entities[i].sid1 = GetPersonID(entities[i].name+"star1");
			entities[i].sid2 = GetPersonID(entities[i].name+"star2");
			entities[i].sid3 = GetPersonID(entities[i].name+"star3");
			}
	    else if (entities[i].type == 6)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name+"arm1");
			entities[i].id3 = GetPersonID(entities[i].name+"arm1");
			}
	    else if (entities[i].type == 7)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name+"arm1");
			entities[i].id3 = GetPersonID(entities[i].name+"arm2");
			}
	    else if (entities[i].type == 8)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name+"arm1");
			entities[i].id3 = GetPersonID(entities[i].name+"arm1");
			}
	    else if (entities[i].type == 9)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name);
			entities[i].id3 = GetPersonID(entities[i].name);
			}
	    else if (entities[i].type == 10)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name);
			entities[i].id3 = GetPersonID(entities[i].name);
			}
	    else if (entities[i].type == 11)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name);
			entities[i].id3 = GetPersonID(entities[i].name);
			}	
	    else if (entities[i].type == 12)
	    {
			entities[i].id1 = GetPersonID(entities[i].name);
			entities[i].id2 = GetPersonID(entities[i].name);
			entities[i].id3 = GetPersonID(entities[i].name);
			}	
			entities[i].maxhp1 = entities[i].hp1;
			entities[i].maxhp2 = entities[i].hp2;
			entities[i].maxhp3 = entities[i].hp3;
		}

	heads[0].id1 = GetPersonID(entities[0].name+"head");

	for (i=0;i<max_heads;i++)
	{
	  if (heads[i].id1 >= 0 && entities[i].type != 9 && entities[i].type != 10)
	  {
			heads[i].x = blood_dx;
			heads[i].y = 0;
		
			heads[i].vx = 0;
			heads[i].vy = 0;
			heads[i].id1 = GetPersonID(entities[i].name+"head");

			heads[i].name = entities[i].name+"head";
		
			heads[i].frame = 0;
			heads[i].direction = "enemy1";
			heads[i].flamed = 0;
			heads[i].rotation = 0;
			heads[i].layer = gut_layer+1;
			
			
			if (heads[i].name == "head_shred1head")
			{
				heads[i].x = entities[i].x;
				heads[i].y = entities[i].y;
				heads[i].direction = "shred";
				SetPersonIDDirection(heads[i].id1, heads[i].direction);
				heads[i].active = true;
			}
			SetPersonIDX(heads[i].id1, heads[i].x);
			SetPersonIDY(heads[i].id1, heads[i].y);
			SetPersonIDLayer(heads[i].id1, heads[i].layer);
		}
	}

	for (i=0;i<d_count;i++)
	{
		doors[i].id1 = GetPersonID(doors[i].name);
//		doors[i].id2 = GetPersonID(doors[i].name);
//		doors[i].id3 = GetPersonID(doors[i].name);
		
		if (doors[i].type == 2)
		{
			for (j=0;j<(doors[i].name).length;j++)
			{
				if ((doors[i].name).charAt(j) == 'T')
				  break;
			}
			j++;
			
			for (k=0;k<d_count;k++)
			{
				if (doors[k].name == (doors[i].name).substr(j, (doors[i].name).length))
				{
					doors[i].target = k;
					break;
				}
			}
		}
	}


	
	for (i=0;i<max_trails;i++)
	{
		btrails[i].id1 = GetPersonID("bt"+i);
	}

	for (i=0;i<max_beams;i++)
	{
		beams[i].id1 = GetPersonID("beam"+i);
	}


	for (i=0;i<max_spark;i++)
	{
		spark[i].id1 = GetPersonID("ss"+i);
	}	

	for (i=0;i<max_blood;i++)
	{
		blood[i].id1 = GetPersonID("bs"+i);
	}

	SetupExplosions();
	SetupGrenades();
	SetupShrapnel();
	
	for (i=0;i<max_casings;i++)
	{
	  casings[i].id1 = GetPersonID("c"+i);
		casings[i].x = blood_dx;
		casings[i].y = blood_dy;
	}

	for (i=0;i<max_railguns;i++)
	{
		railguns[i].sx = 0;
		railguns[i].sy = 0;
		railguns[i].x = 0;
		railguns[i].y = 0;
		railguns[i].timer = 0;
	}

	for (i=0;i<bdrip;i++)
	{
		blood_drip[i].x = blood_dx;
		blood_drip[i].amt = 0;
	}

	
	if (g_current_level == 8 || g_current_level == 10)
	{
		entities[0].dir=-1;
	}
	
	UpdateEntities(0);
	UpdateEntities(0);

	var Blanky = LoadImage("blank.png")
	SetTileImage(189, Blanky);
	SetTileImage(279, Blanky);
	
	eat_camera = 0;	
	
	CreatePerson("e1_test", "e1_test.rss", true);
	SetPersonX("e1_test", -200)
	SetPersonLayer("e1_test", 0);
	g_widthy_id = GetPersonID("e1_test");
	IgnorePersonObstructions("e1_test", true);
	
	CreatePerson("b1_test", "b1_test.rss", true);
	SetPersonX("b1_test", -200)
	SetPersonLayer("b1_test", 0);
	g_bwidthy_id = GetPersonID("b1_test");
	IgnorePersonObstructions("b1_test", true);


	if (loop == false)
		return;
		
	if (entities[0].dir == -1)
		SetMousePosition(Math.floor(GetScreenWidth()/4),Math.floor(GetScreenHeight()/2));
	else
		SetMousePosition(Math.floor(3*GetScreenWidth()/4),Math.floor(GetScreenHeight()/2));
	
	if (g_current_level == -2)
		StartTraining();
	
	
	
	StartLevel();
	
  
  //when done, exit map engine;
  ExitMapEngine();
}

function StartLevel()
{
	if (GameLoop() == 1)
		StartFunct();
}

var fadeout = 0;
var fadestart = 100;
var fademax = 150;

var ftimes = new Object();
var ftimes_amount = 60;
ftimes.start = GetTime();
ftimes.draw = GetTime();
ftimes.entities = GetTime();
ftimes.etc = GetTime();

var g_rumble = -1;

var cam_xoff = 0;
var cam_yoff = 0;

var max_scripts_commands = 50;
var script_commands = new Array(max_scripts_commands);

var eat_camera = 0;

function GameLoop()
{
	g_supernaut_active = 0;
//	naut1.hp = naut
	eat_camera = 0;
	g_upate_input_suspend = false;
	for (i=0;i<max_scripts_commands;i++)
		script_commands[i] = "";
	var framerate = 1000/30;
	var surface;
	var fadein = 0;
	g_recording_pressed = false;
	g_recording = false;
	naut2.dir2="wait";

	UpdatePlayer();
	
	var start_time = GetTime();
	fadeout = 0;
	fadestart = 100;
	fademax = 150;
	g_frames = 0;
	var frame_skip = 0;
	var flag = 0;
	var gl_last = GetTime();

	cam_xoff = 0
	cam_yoff = 0;

	SetCameraX(entities[0].x+cam_xoff);
	SetCameraY(entities[0].y+cam_yoff);			

	//PlayMusic(0);

	StartHeart();
	g_rumble = -1;

	bg_x1 = -(bg11.width-320)*(entities[0].x/(GetLayerWidth(0)*16));
	bg_y1 = -(bg11.height-240)*(entities[0].y/(GetLayerHeight(0)*16));
	bg15_x1 = -(bg15.width-320)*(entities[0].x/(GetLayerWidth(0)*16));
	bg15_y1 = -(bg15.height-240)*(entities[0].y/(GetLayerHeight(0)*16));
	bg18_x1 = -(bg18.width-320)*(entities[0].x/(GetLayerWidth(0)*16));
	bg18_y1 = -(bg18.height-240)*(entities[0].y/(GetLayerHeight(0)*16));

	//play this level's music
	StartMusic();

	for (gl=0;gl<50;gl+=4)
	{
		DrawBackGroundImage();
		DroneSet();
		RenderMap();
		DroneReset();
		DrawRailguns();
		DrawHud();
				
		Rectangle(0,0,GetScreenWidth(),GetScreenHeight(), CreateColor(0,0,0,255-255*(gl)/(50)));
		FlipScreen();

		while(GetTime()-gl_last < framerate);
		gl_last = GetTime();
	}

	g_exit_level =-1;
	
	ftimes.start = GetTime();
	ftimes.draw = GetTime();
	ftimes.entities = GetTime();
	ftimes.etc = GetTime();
	
	var temptempstr = "";
	
	while (fadeout <= fademax)
	{
		ftimes.start = GetTime();

		flag = 0;

			if (oblit_frame > 5)
			{
				SetCameraX(entities[0].x+cam_xoff+(oblit_max-oblit_frame)*Math.random()/10);
				SetCameraY(entities[0].y+cam_yoff+(oblit_max-oblit_frame)*Math.random()/10);
			}
			if (sounds[81].isPlaying() == true)
			{
//				SetCameraX(entities[0].x+cam_xoff+(1-sounds[81].getPosition()/sounds[81].getLength())*(Math.random()*4-2));
				//SetCameraY(entities[0].y+cam_yoff+(1-sounds[81].getPosition()/sounds[81].getLength())*(Math.random()*4-2));
				g_rumble = 2*(1-sounds[81].getPosition()/sounds[81].getLength());
			}
			else if (sounds[81].isPlaying() == false && g_current_level > 9 && g_current_level < 18 && naut2.dir2 != "headbutt")
			{
				g_rumble = -1;
			}


			if ((entities[0].invince > 0 || (fadeout < 75 && entities[0].hp <=0)) && g_frames%2 == 0)
			{
				for (i=1;i<max_weapons_1;i++)
				{
					entities[0]["la"+i] = GetPersonIDLayer(entities[0]["id"+i]);
					SetPersonIDLayer(entities[0]["id"+i], 0);
				}
			}
			DrawBackGroundImage();
			DroneSet();
			
			if (FixKeyPlay() == true)
			{
				start_time = GetTime()-g_frames*framerate;
			}
			RenderMap();
			
			DroneReset();
			if ((entities[0].invince > 0 ||entities[0].hp <=0)&& g_frames%2 == 0)
			{
				for (i=1;i<max_weapons_1;i++)
				{
					SetPersonIDLayer(entities[0]["id"+i], entities[0]["la"+i]);
				}
			}

			DrawRailguns();
			if (oblit_shield > 0)
				DrawOblitShield();
			if (oblit_frame > 0)
				DrawObliterator();
			DrawHud();
				
			if (fadeout > fadestart)
			{
				Rectangle(0,0,GetScreenWidth(),GetScreenHeight(), CreateColor(0,0,0,255*(fadeout-fadestart)/(fademax-fadestart)));
				FadeMusic(1-(fadeout-fadestart)/(fademax-fadestart));
			}


			if (IsKeyPressed(g_recording_key) && !g_recording_pressed)
			{
				if (g_recording == false)
					g_recording = true;
				else
					g_recording = false;
					
				g_recording_pressed = true;
			}
			if (IsKeyPressed(g_recording_key) == false)
			{
				g_recording_pressed = false;
			}
				RecordNow();
			if (g_recording)
			{
				RecordNow();
			}
//			font.drawText(0,0, boss2.x);
			FlipScreen();
			
			if (g_frames%ftimes_amount == 0)
				ftimes.draw = GetTime()-ftimes.start;

		while(GetTime()-start_time < g_frames*framerate)
			flag=1;

		if (flag !=1)
		  frame_skip++;
		else
		  frame_skip = 0;
		  
		if (frame_skip>0)
		{
			frame_skip=0;
			start_time = GetTime()-g_frames*framerate;
		}
		g_frames++;
		if (script_commands[(g_frames)%max_scripts_commands] != "")
		{
			temptempstr = script_commands[(g_frames)%max_scripts_commands]
			script_commands[(g_frames)%max_scripts_commands] = "";
			DoScript(temptempstr);
		}
		
		if (entities[0].hp <=0)
		{
			fadeout++;
		}

		if (entities[0].hp > 0)
			UpdateVariables();


		if (g_rumble<0)
		{
			SetCameraX(entities[0].x+cam_xoff);
			SetCameraY(entities[0].y+cam_yoff);
		}
		else
		{
			SetCameraX(entities[0].x-g_rumble+2*g_rumble*Math.random()+cam_xoff);
			SetCameraY(entities[0].y-g_rumble+2*g_rumble*Math.random()+cam_yoff);
		}

		if (oblit_frame > 6)
		{
			oblit_frame--;
		}
		else
		{
		  if (oblit_frame <1)
		  {
				if (g_rumble<0)
				{
					SetCameraX(entities[0].x+cam_xoff);
					SetCameraY(entities[0].y+cam_yoff);
				}
				else
				{
					SetCameraX(entities[0].x-g_rumble+2*g_rumble*Math.random()+cam_xoff);
					SetCameraY(entities[0].y-g_rumble+2*g_rumble*Math.random()+cam_yoff);
				}

				ftimes.entities_start = GetTime();
				
				UpdateEntities();

				if (g_frames%ftimes_amount == 0)
					ftimes.entities = GetTime()-ftimes.entities_start;
				ftimes.entities_start = GetTime();

				UpdateDoors();
				UpdateGrenades();
				UpdateExplosions();
				UpdateShrapnel();
//				UpdateShrapnel(1);
				//UpdateShrapnel(1);
				UpdateRailguns();
				UpdateBeams();
				
				if (g_frames%ftimes_amount == 0)
					ftimes.etc = GetTime()-ftimes.entities_start;

				if (entities[0].hp > 0)
				{
					var thingy = UpdateInput();
					if (thingy != 0)
					{
						return thingy;
					}
				}
			}
			UpdateCasings();
			UpdateBlood();	

		  if (oblit_frame <= 6 && oblit_frame > 0)
		  {
 				UpdateEntitiesFrames();
				UpdateRailguns();
// 				if (g_frames%8 == 0)
//					oblit_frame--;
				oblit_frame-=0.125;
				start_time = GetTime()-(g_frames-1)*framerate;
		  }
		}
		
		

		if ((g_exit_level >=0 ||  boss2.ftimer > boss2.ftimermax) && (entities[0].hp > 0||  boss2.ftimer > boss2.ftimermax))
		{

			break;
		}
//		naut1.hp1 -=100
	}


	if (g_exit_level >=0 && entities[0].hp > 0)
	{
		if ((g_supernaut_active == 1 && naut1.hp1 <= 0)||(g_supernaut_active == 2 && naut2.hp1 <= 0))
		{
			PlaySound(69);

			for (gl=0;gl<14; gl+=1)
			{
				DrawBackGroundImage();
				DroneSet();
				RenderMap();
				DroneReset();
				DrawRailguns();
				DrawHud();
				if (gl % 2== 0)
					Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255,255));
							
//				FadeMusic(1-gl/50);
				FlipScreen();
			
				while(GetTime()-gl_last < framerate);
				gl_last = GetTime();
			}

			Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255,255));
			FlipScreen();
			
			gl_last = GetTime();
			while(GetTime()-gl_last < 2000)
			{
				Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255,255));
				FlipScreen();
			}
			gl_last = GetTime();
			for (gl=0;gl<50; gl+=1/2)
			{
				DrawBackGroundImage();
				DroneSet();
				RenderMap();
				DroneReset();
				DrawRailguns();
				DrawHud();
				Rectangle(0,0,GetScreenWidth(),GetScreenHeight(), CreateColor(255,255,255,255-255*(gl)/(50)));
							
//				FadeMusic(1-gl/50);
				FlipScreen();
			
				while(GetTime()-gl_last < framerate);
				gl_last = GetTime();
			}
			gl_last = GetTime();
			for (gl=0;gl<50; gl+=1)
			{
				DrawBackGroundImage();
				DroneSet();
				RenderMap();
				DroneReset();
				DrawRailguns();
				DrawHud();
							
//				FadeMusic(1-gl/50);
				FlipScreen();
			
				while(GetTime()-gl_last < framerate);
				gl_last = GetTime();
			}

		}
		gl_last = GetTime();
		for (gl=0;gl<=50 && g_cancel_fade == false;gl+=2)
		{
			DrawBackGroundImage();
			DroneSet();
			RenderMap();
			DroneReset();
			DrawRailguns();
			DrawHud();
							
			Rectangle(0,0,GetScreenWidth(),GetScreenHeight(), CreateColor(0,0,0,255*(gl)/(50)));
			FadeMusic(1-gl/50.0);
			FlipScreen();
			
			while(GetTime()-gl_last < framerate);
			gl_last = GetTime();
		}
		PauseHeart();
		FlipScreen();
		ShowEndingScreen();
		StartFunct(g_exit_level);
	}
	else if (boss2.ftimer > boss2.ftimermax&& entities[0].hp > 0)
	{
		//the player has won!!
		ShowFinalEnding();
		RestartGame();
	}
	else
	{
		//the player died
		WriteResetInfo(g_reset_load);
		RestartGame();
	}
}

var g_heart_die = -1;
var g_heart_max = 60;


function UpdateVariables()
{
	if (g_chain_cc > 0 )
		g_chain_cc--;
	if (g_sword_cc > 0 )
		g_sword_cc--;
	if (g_boss_cc < g_boss_norm && g_boss_cc > 0)
		g_boss_cc--;

	if (g_statics > 0)
		g_statics--;
		
	if (g_heart_die > 0)
	{
		g_heart_die--;
		g_rumble = 2*g_heart_die/g_heart_max;
		if (g_heart_die == 20)
			PlaySound(126);
	}

	if (g_current_level == 11 || g_current_level == 13 || g_current_level == 14|| g_current_level == 15)
	{
		bg_x1 = -(bg11.width-320)*(entities[0].x/(GetLayerWidth(0)*16));
		bg_y1 = -(bg11.height-240)*(entities[0].y/(GetLayerWidth(0)*16));
		bg15_x1 = -(bg15.width-320)*(entities[0].x/(GetLayerWidth(0)*16));
		bg15_y1 = -(bg15.height-240)*(entities[0].y/(GetLayerWidth(0)*16));
		bg18_x1 = -(bg18.width-320)*(entities[0].x/(GetLayerWidth(0)*16));
		bg18_y1 = -(bg18.height-240)*(entities[0].y/(GetLayerWidth(0)*16));

	}

	if (g_frames%2 == 0)
	{
		adren_frame++;
	
		if (adren_timer > 0)
		{
			adren_timer--;
			if (adren_timer <= 0)
			{
				adren_timer = -adren_max;
			}
		}
		if (adren_timer < 0)
		{
			entities[0].stam-=g_stam_use*4;
			if (entities[0].stam<0)
			  entities[0].stam = 0;
			
			adren_timer++;
			if (adren_timer >= 0)
				adren_timer = 0;
		}
	}

	//stam regen
	if (g_isrunning == false && adren_timer >=0)
		entities[0].stam+=g_stam_regen;
	if (PlayerResting()==true)
	{
		entities[0].stam+=g_stam_regen*3;
	
	}


	//hp regen
	var conn = 1;
	if (g_chosen_diff == 0)
		conn = 1.33;
	if (g_chosen_diff == 2)
		conn = 0.66;

	//if (adren_timer == 0)
		//entities[0].hp+=conn*g_hp_regen;
	if (adren_timer > 0)
		entities[0].hp+=conn*g_hp_regen*g_hp_adren;
		

	if (entities[0].stam > 10)
	  entities[0].stam = 10;

	if (entities[0].hp > entities[0].maxhp)
	  entities[0].hp = entities[0].maxhp;
	  
	//gore_score stuff
	if (gore_counter > 0)
	{
		gore_counter--;
		if (gore_counter <=0)
		{
			if (gore_multi > 2)
				gore_multi=Math.ceil(gore_multi/2);
			else
				gore_multi=1;
			
			gore_next = 5+gore_multi;

			
			if (gore_multi <=1)
			{
				gore_counter = 0;
				gore_level = 0;
			}
			else
			{
				gore_counter = gore_max;
			}
		}
	}
	  
}



var hud_case = LoadImage("hud_casings1.png");
var hud_shell = LoadImage("hud_shells1.png");
var hud_rail = LoadImage("hud_rail1.png");
var hud_gren = LoadImage("hud_grenade1.png");
var hud_shrap = LoadImage("hud_shrap1.png");
var hud_rock = LoadImage("hud_rock1.png");
var hud_oblit = LoadImage("hud_oblit.png");
var hud_chain = LoadImage("hud_chain.png");

var hud_weaps = new Array(8);
for (i=0;i<8;i++)
{
	hud_weaps[i] = LoadImage("hud_"+(i+1)+".png");
}
var hud_arm_ico = LoadImage("hud_0.png");

var g_stam_regen = 0.025;
var g_stam_use = 0.05;
var g_hp_regen = 0.001;
var g_hp_adren =10;


var hud_adren_panel = LoadImage("adren_panel1.png");
var hud_adren_back = LoadImage("adren_back.png");
var hud_adren_back2 = LoadImage("adren_back2.png");
var hud_adren = LoadImage("adren1.png");
var hud_armour = LoadImage("armour1.png");

var adren_frame = 0;
var g_chain_cc = 0;
var g_sword_cc = 0;
var g_boss_cc = 43;
var g_boss_norm = 43;
var g_colour_reds = CreateColor(255,32,23,160);

function DrawHud(mmanage)
{
		var ft = 0;
		var ft2 = 0;
		var fm = boss2.ftimermax;
		if (g_boss_active == 2)
		{
			ft = Math.floor(boss2.ftimer/4);
			ft2 = boss2.ftimer;
		}

		hud.blit(0,-ft);
		SetClippingRectangle(13,0-ft,(entities[0].hp/entities[0].maxhp)*86, 32)		
		hp_bar.blit(0,0-ft);
		SetClippingRectangle(69,0-ft,(entities[0].stam/max_stam)*34, 32)
		stam_bar.blit(0,0-ft);
	
	//9mm
		SetClippingRectangle(148,16-ft-Math.ceil(13*ammo_array[0].curammo/ammo_array[0].maxammo), 4, Math.ceil(13*ammo_array[0].curammo/ammo_array[0].maxammo));
		hud_case.blit(148,3-ft);
		SetClippingRectangle(148+4,16-ft-Math.ceil(13*ammo_array[0].curclip/ammo_array[0].maxclip), 4, Math.ceil(13*ammo_array[0].curclip/ammo_array[0].maxclip));
		hud_case.blit(148,3-ft);

		SetClippingRectangle(148,16-ft-Math.ceil(13*ammo_array[1].curammo/ammo_array[1].maxammo), 14, Math.ceil(13*ammo_array[1].curammo/ammo_array[1].maxammo));
		hud_gren.blit(148,3-ft);

	//magnum
		SetClippingRectangle(161,16-ft-Math.ceil(13*ammo_array[2].curammo/ammo_array[2].maxammo), 4, Math.ceil(13*ammo_array[2].curammo/ammo_array[2].maxammo));
		hud_case.blit(161,3-ft);
		SetClippingRectangle(161+4,16-ft-Math.ceil(13*ammo_array[2].curclip/ammo_array[2].maxclip), 4, Math.ceil(13*ammo_array[2].curclip/ammo_array[2].maxclip));
		hud_case.blit(161+4,3-ft);

		SetClippingRectangle(161,16-ft-Math.ceil(13*ammo_array[1].curammo/ammo_array[1].maxammo), 14, Math.ceil(13*ammo_array[1].curammo/ammo_array[1].maxammo));
		hud_gren.blit(161,3-ft);

	//shotgun

		SetClippingRectangle(174,16-ft-Math.ceil(13*ammo_array[3].curammo/ammo_array[3].maxammo), 5, Math.ceil(13*ammo_array[3].curammo/ammo_array[3].maxammo));
		hud_shell.blit(174,3-ft);
		SetClippingRectangle(174+5,16-ft-Math.ceil(13*ammo_array[3].curclip/ammo_array[3].maxclip), 5, Math.ceil(13*ammo_array[3].curclip/ammo_array[3].maxclip));
		hud_shell.blit(174,3-ft);

	//rifle
		SetClippingRectangle(187,16-ft-Math.ceil(13*ammo_array[4].curammo/ammo_array[4].maxammo), 4, Math.ceil(13*ammo_array[4].curammo/ammo_array[4].maxammo));
		hud_case.blit(187,3-ft);
		SetClippingRectangle(187+4,16-ft-Math.ceil(13*ammo_array[4].curclip/ammo_array[4].maxclip), 4, Math.ceil(13*ammo_array[4].curclip/ammo_array[4].maxclip));
		hud_case.blit(187+4,3-ft);

		SetClippingRectangle(187,16-ft-Math.ceil(13*ammo_array[5].curammo/ammo_array[5].maxammo), 14, Math.ceil(13*ammo_array[5].curammo/ammo_array[5].maxammo));
		hud_gren.blit(187,3-ft);
	//rockets
		SetClippingRectangle(200,16-ft-Math.ceil(13*(ammo_array[6].curammo+ammo_array[6].curclip)/(ammo_array[6].maxammo+1)), 14, Math.ceil(13*(ammo_array[6].curammo+ammo_array[6].curclip)/(ammo_array[6].maxammo+1))+3);
		hud_rock.blit(200,3-ft);

	//rail
		SetClippingRectangle(213,16-ft-Math.ceil(13*ammo_array[7].curammo/ammo_array[7].maxammo), 6, Math.ceil(13*ammo_array[7].curammo/ammo_array[7].maxammo));
		hud_rail.blit(213,3-ft);
		SetClippingRectangle(213+6,16-ft-Math.ceil(13*ammo_array[7].curclip/ammo_array[7].maxclip), 5, Math.ceil(13*ammo_array[7].curclip/ammo_array[7].maxclip));
		hud_rail.blit(213,3-ft);


	//shrap
		SetClippingRectangle(226,16-ft-Math.ceil(13*(ammo_array[8].curammo+ammo_array[8].curclip)/(ammo_array[8].maxammo+1)), 14, Math.ceil(13*(ammo_array[8].curammo+ammo_array[8].curclip)/(ammo_array[8].maxammo+1))+3);
		hud_shrap.blit(226,3-ft);

	//oblit
		SetClippingRectangle(239,16-ft-Math.ceil(13*(ammo_array[9].curammo+ammo_array[9].curclip)/(ammo_array[9].maxammo+1)), 14, Math.ceil(13*(ammo_array[9].curammo+ammo_array[9].curclip)/(ammo_array[9].maxammo+1))+3);
		hud_oblit.blit(239,3-ft);
		
	//armour
		SetClippingRectangle(136,16-ft-Math.ceil(13*(ammo_array[11].curammo)/(ammo_array[11].maxammo)), 14, Math.ceil(13*(ammo_array[11].curammo)/(ammo_array[11].maxammo))+3);
		hud_armour.blit(136,3-ft);
	


		SetClippingRectangle(0,0, GetScreenWidth(),GetScreenHeight());

		
		var sy = GetScreenHeight()-bullet_panel.height;

		if (weap_possess[11] == true)
		{
			bullet_panel3.blit(0,sy+g_sword_cc-2+ft);
		}

		bullet_panel.blit(0,sy+ft);
		if (weap_possess[10] == true)
		{
			bullet_panel2.blit(0,sy+g_chain_cc+ft);
			SetClippingRectangle(68,sy+g_chain_cc+17+ft, Math.ceil(26*(ammo_array[12].curammo)/(ammo_array[12].maxammo)), 14);
			hud_chain.blit(68,sy+g_chain_cc+17+ft);
			SetClippingRectangle(0,0, GetScreenWidth(),GetScreenHeight());
		}



		if (g_supernaut_active == 1)
		{
			if (g_boss_cc == g_boss_norm)
				g_boss_cc--;
			boss_hud.blit(0,sy+g_boss_cc+ft);
			if (naut1.hp1/naut1.maxhp > 0)
				Rectangle(135, sy+g_boss_cc+18+ft, (284-137)*(naut1.hp1/naut1.maxhp), 9, g_colour_reds);
		}
		else if (g_supernaut_active == 2)
		{
			if (g_boss_cc == g_boss_norm)
				g_boss_cc--;
			boss_hud.blit(0,sy+g_boss_cc+ft);
			if (naut2.hp1/naut2.maxhp > 0)
				Rectangle(135, sy+g_boss_cc+18+ft, (284-137)*(naut2.hp1/naut2.maxhp), 9, g_colour_reds);
		}

		if (g_boss_active == 1)
		{
			if (g_boss_cc == g_boss_norm)
				g_boss_cc--;
			boss_hud.blit(0,sy+g_boss_cc+ft);
			if (boss.stage_p/boss.stage_m > 0)
				Rectangle(135, sy+g_boss_cc+18+ft, (284-137)*(boss.stage_p/boss.stage_m), 9, g_colour_reds);
		}

		if (g_boss_active == 2)
		{
			
			if (g_boss_cc == g_boss_norm)
				g_boss_cc--;

			if (g_boss_cc > 0)
			{
				boss_hud.blit(0,sy+(g_boss_norm-g_boss_cc)+ft);
			}
			boss_hud.blit(0,sy+g_boss_cc+ft);
			if (boss2.hp/boss2.maxhp > 0)
				Rectangle(135, sy+g_boss_cc+18+ft, (284-137)*(boss2.hp/boss2.maxhp), 9, g_colour_reds);
		}


		if (g_wipe_active > 0)
		{
			if (g_boss_cc == g_boss_norm)
				g_boss_cc--;
			boss_hud.blit(0,sy+g_boss_cc+ft);
			if (entities[g_wipe_active].hp/entities[g_wipe_active].maxhp > 0)
				Rectangle(135, sy+g_boss_cc+18+ft, (284-137)*(entities[g_wipe_active].hp/entities[g_wipe_active].maxhp), 9, g_colour_reds);
		}
		if (g_id_active > 0 && id_stage == 3)
		{
			if (g_boss_cc == g_boss_norm)
				g_boss_cc--;
			boss_hud.blit(0,sy+g_boss_cc+ft);
/*			
			if (entities[g_id_active].hp1/entities[g_id_active].maxhp > 0)
				Rectangle(135, sy+g_boss_cc+18, (284-137)*(entities[g_id_active].hp1/entities[g_id_active].maxhp), 9, g_colour_reds);
*/	
			if (id_stage == 3)
				Rectangle(135, sy+g_boss_cc+18+ft, (284-137)*((7-id_walk_back)/8), 9, g_colour_reds);
			else
				Rectangle(135, sy+g_boss_cc+18+ft, (284-137)*(1), 9, g_colour_reds);
		}

		bullet_font.drawText(20, sy+6+ft, "CLIP: "+ammo_array[cur_weap].curclip);
		bullet_font.drawText(10, sy+17+ft, "AMMO: "+ammo_array[cur_weap].curammo);

		if (cur_weap == 0 || cur_weap == 2)
			bullet_font.drawText(10, sy+23+ft, "ALT:  "+ammo_array[1].curammo);
		else if (cur_weap == 4)
			bullet_font.drawText(10, sy+23+ft, "ALT:  "+ammo_array[5].curammo);
		else
			bullet_font.drawText(10, sy+23+ft, "ALT:   --");
		
//gore score

	bullet_font.drawText(GetScreenWidth()-6-bullet_font.getStringWidth(""+gore_score), 9-ft, gore_score);

	var stringy = "x"+gore_multi;
	
	bullet_font.drawText(314-bullet_font.getStringWidth(stringy), 4-ft, stringy);



	if (gore_counter > 0)
	{
		Line(270,3, 270+(43*gore_level/gore_next),3-ft,CreateColor(160,0,32,160));
		Line(270,4, 270+(43*gore_counter/gore_max),4-ft,CreateColor(0,160,32,160));
	}

//calculate time:
	var tseconds=Math.floor(g_total_time+g_frames*25/750);
	var mins=Math.floor(tseconds/60)%60;
	var hours=Math.floor(tseconds/3600);
	var secs=tseconds%60;
	
	if (hours > 9)
	{
		hours = 9;
		mins = 59;
		secs = 59;
	}
	
	var string = hours+":";
	

	if (mins<10)
	  string+= "0"+mins+":";
	else
	  string+= ""+mins+":";

	if (secs<10)
		string += "0"+secs;
	else
		string += ""+secs;
	
	

	bullet_font.drawText(GetScreenWidth()-12-bullet_font.getStringWidth(string), 22-ft, string);



//adren meter
		hud_adren_panel.blit(GetScreenWidth()-hud_adren_panel.width, GetScreenHeight()+ft-hud_adren_panel.height);

		if (adren_timer > 0)
		{
			SetClippingRectangle(0,GetScreenHeight()+5+9+ft-hud_adren_panel.height+Math.floor(27*(adren_max-adren_timer)/adren_max), GetScreenWidth(),27);
			hud_adren_back2.blitMask(GetScreenWidth()-hud_adren_panel.width+6, GetScreenHeight()+ft+5+9-hud_adren_panel.height, CreateColor(255,255,255, 180+45*Math.sin(adren_frame*2*3.14159/70)));
			if (adren_timer < 10)
				sounds[32].setVolume(255*adren_timer/10);
		}
		else if (adren_timer < 0)
		{
			sounds[32].stop();
			SetClippingRectangle(0,GetScreenHeight()+5+ft+9-hud_adren_panel.height+Math.floor(27*(-adren_timer)/adren_max), GetScreenWidth(),27);
			hud_adren_back.blitMask(GetScreenWidth()-hud_adren_panel.width+6, GetScreenHeight()+ft+5+9-hud_adren_panel.height, CreateColor(255,255,255, 180+45*Math.sin(adren_frame*2*3.14159/70)));
		}
		else
		{
			sounds[32].stop();
			SetClippingRectangle(0,0, GetScreenWidth(),GetScreenHeight());
			hud_adren_back.blitMask(GetScreenWidth()-hud_adren_panel.width+6, GetScreenHeight()+5+ft+9-hud_adren_panel.height, CreateColor(255,255,255, 180+45*Math.sin(adren_frame*2*3.14159/70)));
		}

		SetClippingRectangle(0,0, GetScreenWidth(),GetScreenHeight());
		if (ammo_array[10].curammo < 10)
			bullet_font.drawText(12+GetScreenWidth()-hud_adren_panel.width, 4+ft+GetScreenHeight()-hud_adren_panel.height, " "+ammo_array[10].curammo);
		else
			bullet_font.drawText(12+GetScreenWidth()-hud_adren_panel.width, 4+ft+GetScreenHeight()-hud_adren_panel.height, ammo_array[10].curammo);

		for (i=0;i<8;i++)
		{ 
			if (weap_possess[i] == 1)
			{
				hud_weaps[i].blit(147+13*i, 18-ft);
			}
		}

		if (ammo_array[11].curammo > 0)
			hud_arm_ico.blit(135, 18-ft);

		if (mmanage != false)
			ManageMouse();
		
		
//		crosshair.blit(GetMouseX()-crosshair.width/2, GetMouseY()-crosshair.height/2);
		crosshair.blit(lastxm-crosshair.width/2, lastym-crosshair.height/2);		

		if (g_boss_active == 2)
		{
			Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,ft2*255/fm));
		}


		if (g_statics > 0)
		{
			if (sounds[96].isPlaying() == false)
			{
				sounds[96].play(true);
			}
			sounds[96].setVolume(225*Math.sin(3.14159*g_statics/100)*sound_level);
//			sounds[96].setPitch(Math.sin(3.14159*g_statics/50)*0.1+0.95);
			
			id_mask.blitMask(0,0,CreateColor(255,255,255,Math.floor(64*Math.sin(3.14159*g_statics/100))));

		}
		else
		{
			if (sounds[96].isPlaying() == true)
				sounds[96].stop();
		}
		
		if (g_wt_counter > 0)
		{
			g_wt_counter--;
			DrawWaveFont();
		}
		
		DrawAmmoTexts();
		
		//a central location for it.
		UpdateMusic();
}

var g_lastammofup = 0;
font2b.setColorMask(CreateColor(0,255,48, 255));

function DrawAmmoTexts()
{
	var atx = 1;
	var aty = 32;
	var flagy = 0;
	
	if (g_frames != g_lastammofup)
	{
		g_lastammofup = g_frames;
		flagy = 1;
	}

	for (da = 0; da <max_ammo_texts;da++)
	{
		if (ammotext[da].counter >= 0 && ammotext[da].text!="")
		{
			if (ammotext[da].counter < atext_fade)
				font2b.setColorMask(CreateColor(0,255,48, 160*(ammotext[da].counter/atext_fade)));
			else
				font2b.setColorMask(CreateColor(0,255,48, 160));
			font2b.drawText(atx, aty+da*font2.getHeight(), ammotext[da].text);
			if (flagy==1)
			{
				ammotext[da].counter--;
			}
		}
	}

}



var active_w = 480;
var active_h = 360;

var active_ai_w = 320;
var active_ai_h = 240;

var mantis_active_ai_w = 80;
var mantis_active_ai_h = 60;

var max_weapons_1 = 13;

var barrel_up = -1;

function UpdateEntities(nume)
{
	barrel_up = -1;
	var speed;
	var sx,sy;
	var t_string;
	var t_layer = 0;
	var boooo = false;
	
	//this is for updating the animation tiles of the map
	UpdateMapEngine();
	
	if (eat_camera == 1)
	{
		for (e=1;e<max_weapons_1;e++)
		{
			SetPersonIDX(entities[0]["id"+e], blood_dx);
		}	
	}
	else
		UpdatePlayer();
	

	if (nume!=0)
	{
		if (AreZonesAt(entities[0].x, entities[0].y, entities[0].layer))
		{
			ExecuteZones(entities[0].x, entities[0].y, entities[0].layer);
		}
	}

  if (!IsKeyPressed(CKEY_F))
			g_open_pressed = false;
			
	var hste = false;

	if (IsKeyPressed(CKEY_F) && g_open_pressed == false)
	{
		g_open_pressed = true;
		hste = HitSwitch(entities[0].x, entities[0].y);
		
		if (hste == false)
		{
			//if obstructed in front of you:...
			st_layer = GetPersonLayer(entities[0].name);
			SetPersonLayer(entities[0].name, 0);
			
			if (IsPersonObstructed(entities[0].name, entities[0].x+8*entities[0].dir, entities[0].y))
			{
				PlaySound(129, true);
			}

	  	SetPersonLayer(entities[0].name, st_layer);
		
		
		}
		
		if (key_record==true)
		{
			var fra = g_frames-frame_st;
			key_array[fra].hs = 1;
		}
	}


	//update the supernaut if it's active
	if (g_supernaut_active > 0)
		SupernautUpdateAI();
	//update the boss if it's active
	if (g_boss_active == 1)
		BossAI();
	else if (g_boss_active == 2)
		Boss2AI();

	var friction = 2.00;

	var test_id = 0;
	var test_x_off = 0;

	for (i=1;i<max_entities;i++)
	{
		if (entities[i].type > 0 && entities[i].active == true&& entities[i].stop == false && entities[i].ambush == false)
		{	
			if (entities[i].type == 4)
			{
				UpdateWipeAI(i);
			}
			else if (entities[i].type == 6)
			{
				UpdateIdAI(i);
			}
			else if (entities[i].type != 2 && entities[i].dir2 != "rise" && entities[i].type != 11)
			{
				//add gravity;
				test_x_off = 0;
				if (entities[i].hp <=0 && entities[i].type != 8)
				{
					test_x_off = 4*entities[i].dir;
				}

				if (!IsEntityInWater(i))
					entities[i].watag = 0;
				else
					entities[i].watag = 1;
				
				if (entities[i].vy < grav_max && !IsPersonOnGround(i))
				{
					if (entities[i].type == 8 && entities[i].hp > 0)
					{
						if (entities[i].vy < grav_max/grav_drone)
							entities[i].vy+=grav_amt;
					}
					else
						entities[i].vy+=grav_amt;
				}
	
				if (IsEntityInWater(i))
				{
					InWater(i);
					if (entities[i].watag == 0 && entities[i].vy > 3)
					{
						PlaySound(128,true);
					}
				}
	
				sx = entities[i].x;
				sy = entities[i].y;
				
				entities[i].x += entities[i].vx;
				entities[i].y += entities[i].vy;
				
				t_layer = GetPersonIDLayer(entities[i].id1);
				SetPersonIDLayer(entities[i].id1, 0);

				test_id = entities[i].id1;
				if (entities[i].hp <= 0 && (entities[i].type == 1 || entities[i].type == 3 || entities[i].type == 7))
					test_id = g_widthy_id;
				
				if (IsPersonIDObstructed(test_id, entities[i].x+test_x_off, entities[i].y) || (entities[i].type == 8 && IsEntityInWater(i) )|| (entities[i].type == 10 && !IsEntityInWater(i)))
				{
					speed = Math.sqrt(entities[i].vx*entities[i].vx + entities[i].vy*entities[i].vy);
					
					for (k=speed-1;k>=0;k--)
					{
						entities[i].x = sx+entities[i].vx*(k/speed);
						entities[i].y = sy+entities[i].vy*(k/speed);
					
						if (!IsPersonIDObstructed(test_id, entities[i].x+test_x_off, entities[i].y) && (entities[i].type != 8 || !IsEntityInWater(i) )&& (entities[i].type != 10 || IsEntityInWater(i)))
							break;
					}
					if (IsPersonIDObstructed(test_id, entities[i].x+test_x_off, entities[i].y)|| (entities[i].type == 8 && IsEntityInWater(i) )|| (entities[i].type == 10 && !IsEntityInWater(i)))
					{
						entities[i].x = sx;
						entities[i].y = sy;
					}

/*
					boooo = false;
					if (IsPersonIDObstructed(entities[i].id1, entities[i].x+1, entities[i].y) && entities[i].vx > 0)
					{
						entities[i].vx = 0;
						boooo = true;
					}
					else if (IsPersonIDObstructed(entities[i].id1, entities[i].x-1, entities[i].y)&& entities[i].vx < 0)
					{
						boooo = true;
						entities[i].vx = 0;
					}
					if (IsPersonIDObstructed(entities[i].id1, entities[i].x, entities[i].y+1) && entities[i].vy > 0)
					{
						entities[i].vy = 0;
						boooo = true;
					}
					else if (IsPersonIDObstructed(entities[i].id1, entities[i].x, entities[i].y-1)&& entities[i].vy < 0)
					{
						boooo = true;
						entities[i].vy = 0;
					}
					
					if (boooo == false)
					{
//						FlipScreen();
						entities[i].vx = 0;
						entities[i].vy = 0;
						if (!IsPersonIDObstructed(entities[i].id1, entities[i].x, entities[i].y+1))
						{
							entities[i].y++;
						}
					}*/
				}
				
				if (entities[i].hp3 <=0 && g_frames%max_entities == i)
					MarkBlood(entities[i].x, entities[i].y+entities[i].h+6);
	
				if (entities[i].vx < 0 && IsEntityOnGround(i))
				{
					entities[i].vx+=friction/4;
					if (entities[i].vx > 0)
						entities[i].vx = 0;
				}
				else if (entities[i].vx > 0 && IsEntityOnGround(i))
				{
					entities[i].vx-=friction/4;
					if (entities[i].vx < 0)
						entities[i].vx = 0;
				}
				
	
				if (IsPersonIDObstructed(test_id, entities[i].x+test_x_off, entities[i].y+1) ||
						IsPersonIDObstructed(test_id, entities[i].x+test_x_off, entities[i].y-1))
				{
					if (entities[i].vy > 3)
						PlaySound(33);
					
					entities[i].vy = 0;
				}
				if (IsPersonIDObstructed(test_id, entities[i].x+1+test_x_off, entities[i].y) ||
						IsPersonIDObstructed(test_id, entities[i].x-1+test_x_off, entities[i].y))
					entities[i].vx = 0;
					
				SetPersonIDLayer(entities[i].id1, t_layer);
			}
			else if (entities[i].type == 2)
			{
				UpdateBarrel(i);
			}
			else if (entities[i].type == 11)
			{
				if (entities[i].hp <=0)
				{
					entities[i].stop = true;
				}
			
			}
			
			if (entities[i].type > 0)
			{
				//incase game data was cleared
			
				if (IsEntityOnGround(i) && entities[i].hp <=0 && entities[i].vx == 0 && entities[i].frame2 >= entity_frames[entities[i].type].die)
				{
					entities[i].stop = true;
				}
	
				if (entities[i].type != 4 && entities[i].type != 6)
					UpdateEntityFrame(i);
	
				if (entities[i].hp > 0)
				{
					if (Math.abs(entities[0].x-entities[i].x) < active_ai_w && Math.abs(entities[0].y-entities[i].y) < active_ai_h)
					{
						if (entities[i].sight == 1)
						{
							if (g_frames%20 == i%20)
							{
								if (EntitySeesPlayer(i))
								{
									entities[i].sight = 2;
								}
							}
						}
						if (entities[i].sight == 0 || entities[i].sight == 2)
						{
							UpdateEntityAi(i);
						}
						if (entities[i].sight == 3)
						{
							if (Math.abs(entities[0].x-entities[i].x) < mantis_active_ai_w && Math.abs(entities[0].y-entities[i].y) < mantis_active_ai_h)
							{
								entities[i].sight = 1;
							}
						}
					}
				}
	
				if (Math.abs(entities[0].x-entities[i].x) > active_w || Math.abs(entities[0].y-entities[i].y) > active_h)
				{
					if (entities[i].sight == 2)
						entities[i].sight = 1;
					
					
					if (entities[i].type != 4 && entities[i].type != 6)
						entities[i].active = false;
				}
			}
		}
		else if (Math.abs(entities[0].x-entities[i].x) < active_w && Math.abs(entities[0].y-entities[i].y) < active_h && entities[i].ambush == false)
		{
		  if (entities[i].type != 4 && entities[i].type != 6)//wipe type
		  {
					entities[i].active = true;
			}
			else
				;//possibily play the ambushing enemy sound
		}
		else if (entities[i].ambush == true)
		{
			if (Math.abs(entities[0].x-entities[i].x) < active_w/2 && Math.abs(entities[0].y-entities[i].y) < active_h/2)
			{
				if (sounds[53].isPlaying() == false && g_frames%next_amb_call == 0 && Math.random()<0.5)
				{
					next_amb_call = Math.floor(Math.random()*32+16);
					PlayAmbush(Math.abs(entities[0].x-entities[i].x)/(active_w), 1-((Math.abs(entities[0].x-entities[i].x) + Math.abs(entities[0].y-entities[i].y))/(active_w/2+active_h/2)));
				}
			}
			
			SetPersonIDX(entities[i].id1, blood_dx);
			SetPersonIDX(entities[i].id2, blood_dx);
			SetPersonIDX(entities[i].id3, blood_dx);

			if (entities[i].sight == 3)
			{
				if (Math.abs(entities[0].x-entities[i].x) < mantis_active_ai_w && Math.abs(entities[0].y-entities[i].y) < mantis_active_ai_h)
				{
					PlaySound(59,true);
					EnemyAmbush(entities[i].name);
					entities[i].sight = 1;
					
				}
			}
		}
	}

	PostBarrelUpdate();
}

function IsEntityOnGround(num)
{
	var test_x_off=0
	var test_id = entities[num].id1;
	if (entities[num].hp <=0&& (entities[num].type == 1 || entities[num].type == 3 || entities[num].type == 7))
	{
		test_id = g_widthy_id;
		test_x_off=entities[num].dir*4;
	}
	
  if (IsPersonIDObstructed(test_id, entities[num].x+test_x_off,entities[num].y+1) && !IsPersonIDObstructed(test_id, entities[num].x+test_x_off,entities[num].y))
		return true;
	return false;
}

function UpdateEntitiesFrames()
{
	for (i=1;i<max_entities;i++)
	{
		if (entities[i].type > 0)
		{
			if (entities[i].type != 4 && entities[i].type != 6)
				UpdateEntityFrame(i);
		}
	}
}

function UpdateEntityFrame(num)
{
	if (entities[num].type == 2)
	{
		UpdateBarrelFrame(num);
		return;
	}

	if (entities[num].type == 11)
	{
		if (entities[num].hp <= 0 && entities[num].target != undefined)
		{
			OpenNameDoor(entities[num].target);
			entities[num].target = undefined;
		}
	}

	if (entities[num].type == 4)
		return;
		
	//whatever
	if (entities[num].vx > 0)
		entities[num].dir = 1;
	if (entities[num].vx < 0)
		entities[num].dir = -1;
		
	var face = "east"
	var facedir = (-1*entities[num].dir+1)/2;
	/*
	font.drawText(0,0, num);
	font.drawText(0,20, entities[num].dir2);
	FlipScreen();
	GetKey();
	*/
	SetPersonIDHorizontalFlip(entities[num].id1, facedir);
	SetPersonIDHorizontalFlip(entities[num].id2, facedir);
	SetPersonIDHorizontalFlip(entities[num].id3, facedir);
	
	if (entities[num].type == 2)
	{
		if (entities[num].hp <= 0)
		{
			SetPersonIDDirection(entities[num].id1, "die1east");
			SetPersonIDFrame(entities[num].id1, 1);
			entities[num].frame2 = 1;
			entities[num].dir2 = "die1";
		}
	}
	
	//update the legs:
	if (entities[num].type == 11)
	{
		if (entities[num].hp <= 0)
		{
			SetPersonIDDirection(entities[num].id1, "die1east");
			SetPersonIDFrame(entities[num].id1, 1);
			entities[num].frame2 = 1;
			entities[num].dir2 = "die1";
		}
		else
		{
			SetPersonIDDirection(entities[num].id1, "idleeast");
			SetPersonIDFrame(entities[num].id1, entities[num].frame2);
			entities[num].dir2 = "idle";

			if (g_frames % (frameupdate*2) == 0)
				entities[num].frame2++;
				
			if (entities[num].frame2 >= entity_frames[entities[num].type].idle)
				entities[num].frame2 = 0;


		}
	}
	else if ((entities[num].dir2).substr(0,3) != "leg" && entities[num].type != 8&& entities[num].type != 10)
	{

	//change dir2 based on current action
		//eg: should be walking, should be dead, etc.
	
		if (entities[num].dir2 == "rise")
		{
			if (g_frames % (2*frameupdate) == 0)
				entities[num].frame2++;
				
			if (entities[num].frame2 >= entity_frames[entities[num].type].rise)
			{
				entities[num].dir2 = "idle";
				entities[num].frame2 = 0;
			}
			
		}
		else if (entities[num].hp<=0 && entities[num].dir2 != "die1"&& entities[num].dir2 != "die2")
		{
			entities[num].hp = 0;
			entities[num].dir2 = "die1";
			entities[num].frame2 = 0;
		}
		else if (entities[num].dir2 == "idle" && entities[num].vx != 0 && IsPersonOnGround(num) == true)
		{
			entities[num].dir2 = "walk";
			entities[num].frame2 = 0;
		}
		
		if (entities[num].dir2 != "walk" && IsPersonOnGround(num) && (entities[num].dir2).substr(0,6) != "attack" && entities[num].hp > 0 && entities[num].vx != 0 && entities[num].dir2 != "rise")
		{
			entities[num].dir2 = "walk";
		}
		else if (entities[num].dir2 != "idle" && IsPersonOnGround(num) && (entities[num].dir2).substr(0,6) != "attack" && entities[num].hp > 0 && entities[num].vx == 0 && entities[num].dir2 != "rise")
		{
			entities[num].dir2 = "idle";
		}

		
		if ((entities[num].dir2).substr(0,3) == "die")
		{
			//update the death frames.
	
			if (g_frames % frameupdate == 0)
				entities[num].frame2++;
				
			if (entities[num].frame2 >= entity_frames[entities[num].type].die)
			{
				entities[num].frame2 = entity_frames[entities[num].type].die;
				
				//set entity to no update.
			}
			//if on last frame, do not update the frames again.
		}
		else if ((entities[num].dir2).substr(0,6) == "injury")
		{
			if (g_frames % frameupdate == 0)
				entities[num].frame2++;
				
			if (entities[num].frame2 > entity_frames[entities[num].type].injury)
			{
				entities[num].dir2 = "idle";
				entities[num].frame2 = 0;
			}
		}
		else if (IsPersonOnGround(num) == true&& entities[num].dir2 != "rise")
		{
			if ((entities[num].dir2).substr(0,6) == "attack")
			{
				//update attack frames
				if (g_frames % frameupdate == 0)
				{
					entities[num].frame2++;
					if (entities[num].frame2 == 1 && entities[num].type != 12)
					{
						if (entities[num].type == 5 )
						{
							if (entities[num].dir2 == "attack1")
								PlaySound(45,true);
							else
								PlaySound(133,true);
						}
						else if (entities[num].type != 9 || entities[num].dir2 != "attack3")
						{
							if (entities[num].type == 7)
								PlaySound(58,true);
							else
								PlaySound(45,true);
						}
					}
				}
					
				if (entities[num].type == 12)
				{
					if (entities[num].dir2 == "attack1" || entities[num].dir2 == "attack2")
					{
						if (g_frames % frameupdate == 0)
						{
//							entities[num].frame2++;
							if (entities[num].frame2 == 3)
							{
								PlaySound(58,true);
							}						
							if (entities[num].frame2 == 4)
								SpriteAttack(num);
						}
					}
					else if (entities[num].dir2 == "attack3")
					{
						if (g_frames % frameupdate == 0)
						{
//							entities[num].frame2++;
							if (entities[num].frame2 == 3)
							{
								//PlaySound(58,true);
							}						
							if (entities[num].frame2 <4 && entities[num].frame2 > 1)
								SpriteShoveAttack(num);
						}
					}
				}
					
				if (entities[num].type == 9 && entities[num].dir2 == "attack3" && entities[num].frame2 > 0)
				{
					if (g_frames % frameupdate == 0)
					{
						if (entities[num].frame2 == 1)
							PlaySound(60,true,0.90);
					}
					DoDroneAttack(entities[num].x, entities[num].y, entities[num].dir, num, true);
				}
		
				if (entities[num].frame2 == 4 && entities[num].type != 12)
				{
					if (entities[num].type == 5 && entities[num].dir2 == "attack2")
					{
					}
					else if (entities[num].type != 9 || entities[num].dir2 != "attack3")
					  SpriteAttack(num);
				}

				if (entities[num].frame2 > entity_frames[entities[num].type].attack)
				{
					entities[num].dir2 = "idle";
					entities[num].frame2 = 0;
				}
			}
			else if (entities[num].dir2 == "walk")
			{
				//it's walking.
				if (g_frames % frameupdate == 0)
				{
					entities[num].frame2++;
					if (entities[num].type == 12)
					{
					}
					else
					{
						if (entities[num].frame2 == 1||entities[num].frame2 == 4)
							PlayEnemyWalk(64*Math.random());
					}
				}
			}
			else if (entities[num].dir2 == "run")
			{
				//it's walking.
				if (g_frames % frameupdate == 0)
				{
					entities[num].frame2++;
					if (entities[num].frame2 == 1||entities[num].frame2 == 4)
						PlayEnemyWalk(64*Math.random());
				}
			}
			else if (entities[num].dir2 == "idle")
			{
				if (g_frames % frameupdate == 0)
					entities[num].frame2++;
			}
		}
		else if (entities[num].dir2 != "rise")
		{
			//enemy is in the air, default is the jump frames
			entities[num].dir2 = "jump";
		
			if (entities[num].vy < 0)
				entities[num].frame2 = 0;
			else
				entities[num].frame2 = 1;
		}
	}
	else if (entities[num].type != 8 && entities[num].type != 10)
	{
		if (entities[num].dir2 == "legfall1")
		{
			if (g_frames % frameupdate == 0)
				entities[num].frame2++;
				
			if (entities[num].frame2 == 4)
			  entities[num].dir2 = "legidle1";
		}
		else
		{
			if (entities[num].hp<=0 && entities[num].dir2 != "legdie1"&& entities[num].dir2 != "legdie2")
			{
				entities[num].hp = 0;
				entities[num].dir2 = "legdie1";
				entities[num].frame2 = 0;
			}
			else if (entities[num].hp > 0 && entities[num].dir2 == "idle" && entities[num].vx != 0 && IsPersonOnGround(num) == true)
			{
			  if (entities[num].hp1 > 0)
					entities[num].dir2 = "legwalk2";
				else
					entities[num].dir2 = "legwalk1";

				entities[num].frame2 = 0;
			}
						
			if (entities[num].dir2 != "legidle1" && IsPersonOnGround(num) && (entities[num].dir2).substr(0,9) != "legattack" && entities[num].hp > 0)
			{
				if (IsPersonIDObstructed(entities[num].id1, entities[num].x+entities[num].vx, entities[num].y))
					entities[num].dir2 = "legidle1";
			}
						
			if ((entities[num].dir2).substr(0,6) == "legdie")
			{
					//update the death frames.
			
				if (g_frames % frameupdate == 0)
					entities[num].frame2++;
						
				if (entities[num].dir2 == "legdie1")
				{
					if (entities[num].frame2 >= entity_frames[entities[num].type].legdie)
					  entities[num].frame2 = entity_frames[entities[num].type].legdie;
				}
				else
				{
					if (entities[num].frame2 >= 7)
					  entities[num].frame2 = 7;
				}
					//if on last frame, do not update the frames again.
			}
			else if ((entities[num].dir2).substr(0,9) == "leginjury")
			{
				if (g_frames % frameupdate == 0)
					entities[num].frame2++;
					
				if (entities[num].frame2 > entity_frames[entities[num].type].injury)
				{
					entities[num].dir2 = "legidle1";
					entities[num].frame2 = 0;
				}
			}
			else if (IsPersonOnGround(num) == true)
			{
				if ((entities[num].dir2).substr(0,9) == "legattack")
				{
					//update attack frames
					if (g_frames % frameupdate == 0)
					{
						entities[num].frame2++;
						if (entities[num].frame2 == 1)
							PlaySound(45,true);
					}
						
					if (entities[num].frame2 == 4)
					  SpriteAttack(num);	
							
					if (entities[num].frame2 >= entity_frames[entities[num].type].attack)
					{
						entities[num].dir2 = "legidle1";
						entities[num].frame2 = 0;
					}
				}
				else if (entities[num].dir2 == "legwalk1" || entities[num].dir2 == "legwalk2")
				{
					//it's walking.
					if (g_frames % (2*frameupdate) == 0)
					{
						entities[num].frame2++;
						if (entities[num].frame2 == 3)
							PlayEnemyCrawl(128*Math.random());
					}
						
					if (entities[num].frame2 > entity_frames[entities[num].type].legwalk)
					{
						entities[num].frame2=0;
						if (entities[num].hp1 > 0 && entities[num].hp2 > 0)
						{
							if (entities[num].dir2 == "legwalk1")
								entities[num].dir2 = "legwalk2";
							else
								entities[num].dir2 = "legwalk1";
						}
						else
						{
							if (entities[num].hp1 > 0)
								entities[num].dir2 = "legwalk1";
							else
								entities[num].dir2 = "legwalk2";
						}
					}
				}
				else if (entities[num].dir2 == "legidle1")
				{
					if (g_frames % frameupdate == 0)
						entities[num].frame2++;
				}
			}
			else
			{
				//enemy is in the air, default is the jump frames
					entities[num].dir2 = "legjump1";
					if (entities[num].vy < 0)
						entities[num].frame2 = 0;
					else
						entities[num].frame2 = 1;
			}
		}
	}
	else if (entities[num].type == 8)
	{
		//drone frame code
		//jump
		//idle
		if (entities[num].hp<=0 && entities[num].dir2 != "die1"&& entities[num].dir2 != "die2")
		{
			entities[num].hp = 0;
			entities[num].dir2 = "die1";
			entities[num].frame2 = 0;
		}
		else if (entities[num].dir2 == "idle" || entities[num].dir2 == "attack1")
		{
			//Update the entity frames
			if (entities[num].wantup == 1)
			{
				if (entities[num].frame2 > 1 && entities[num].frame2 < 6)
				{
					if (g_frames % (frameupdate*2) == 0)
						entities[num].frame2++;
				}
				else
				{
					if (g_frames % frameupdate == 0)
						entities[num].frame2++;
				}
			}
			else if (entities[num].wantup == -1)
			{
				if (entities[num].frame2 < 2 || entities[num].frame2 > 5)
				{
					if (g_frames % (frameupdate*4) == 0)
						entities[num].frame2++;
				}
				else
				{
					if (g_frames % frameupdate == 0)
						entities[num].frame2++;
				}
			
			}
			else
			{
				if (g_frames % frameupdate == 0)
					entities[num].frame2++;
			}
		
			if (entities[num].attackcount > 0)
			{
						//Update the entity frames
				if (g_frames % frameupdate == 0)
				{
					entities[num].attackcount--;
					if (entities[num].attackcount < 0)
						entities[num].attackcount = 0;
					else if (entities[num].attackcount < 8)
					{
						entities[num].dir2 = "idle";
					}
					else if (entities[num].attackcount >8)
					{
						if (entities[num].hp2 > 0)
							DoDroneAttack(entities[num].x, entities[num].y, entities[num].dir, num);
						else if (entities[num].attackcount%2 == 0)
						{
							SpawnBlood(entities[num].x,entities[num].y,entities[num].dir*5+Math.random()*2-1,-2-Math.random()-1,Math.floor(3*Math.random())+1, "w");		
							if (Math.random()<0.5)
								AddBackBlood(Math.floor(entities[num].x/GetTileWidth()),Math.floor(entities[num].y/GetTileHeight()),1);
							
						}
						//do drone attack
					}

				}
			}
		}
		else if ((entities[num].dir2).substr(0,3) == "die")
		{
			//Update the entity frames
			if (g_frames % frameupdate == 0)
				entities[num].frame2++;
				
			if (entities[num].frame2 >= entity_frames[entities[num].type].die)
			{
				entities[num].frame2 = entity_frames[entities[num].type].die;
				
				//set entity to no update.
			}
		}
	}
	else if (entities[num].type == 10)
	{
		//jellyfish frame code
		//jump
		//idle
		if (entities[num].hp<=0 && entities[num].dir2 != "die1"&& entities[num].dir2 != "die2")
		{
			entities[num].hp = 0;
			entities[num].dir2 = "die1";
			entities[num].frame2 = 0;
		}
		else if (entities[num].dir2 == "idle" || entities[num].dir2 == "attack1")
		{
			//Update the entity frames
			if (entities[num].wantup == 1)
			{
				if (entities[num].frame2 > 1 && entities[num].frame2 < 6)
				{
					if (g_frames % (frameupdate*2) == 0)
						entities[num].frame2++;
				}
				else
				{
					if (g_frames % frameupdate == 0)
						entities[num].frame2++;
				}
			}
			else if (entities[num].wantup == -1)
			{
				if (entities[num].frame2 < 2 || entities[num].frame2 > 5)
				{
					if (g_frames % (frameupdate*4) == 0)
						entities[num].frame2++;
				}
				else
				{
					if (g_frames % frameupdate == 0)
						entities[num].frame2++;
				}
			
			}
			else
			{
				if (g_frames % frameupdate == 0)
					entities[num].frame2++;
			}
		
			if (entities[num].attackcount > 0)
			{
						//Update the entity frames
				if (g_frames % frameupdate == 0)
				{
					entities[num].attackcount--;
					if (entities[num].attackcount < 0)
						entities[num].attackcount = 0;
					else if (entities[num].attackcount <3)
					{
						entities[num].dir2 = "idle";
					}
					else if (entities[num].attackcount > 3)
					{
						if (entities[num].hp > 0)
							DoJellyAttack(entities[num].x, entities[num].y, entities[num].dir, num);
						//do drone attack
					}

				}
			}
		}
		else if ((entities[num].dir2).substr(0,3) == "die")
		{
			//Update the entity frames
			if (g_frames % frameupdate == 0)
				entities[num].frame2++;
				
			if (entities[num].frame2 >= entity_frames[entities[num].type].die)
			{
				entities[num].frame2 = entity_frames[entities[num].type].die;
				
				//set entity to no update.
			}
		}
	}

	SetPersonIDFrame(entities[num].id1, entities[num].frame2);
	SetPersonIDFrame(entities[num].id2, entities[num].frame2);
	SetPersonIDFrame(entities[num].id3, entities[num].frame2);

	SetPersonIDDirection(entities[num].id1, entities[num].dir2+"east");
	SetPersonIDDirection(entities[num].id2, entities[num].dir2+"east");
	SetPersonIDDirection(entities[num].id3, entities[num].dir2+"east");



	entities[num].frame2 = GetPersonIDFrame(entities[num].id1);


			//update character info in the map
	if (entities[num].ambush == true)
	{
		SetPersonIDX(entities[num].id1, blood_dx);
		SetPersonIDX(entities[num].id2, blood_dx);
		SetPersonIDX(entities[num].id3, blood_dx);
	}
	else
	{
		SetPersonIDX(entities[num].id1, entities[num].x);
		SetPersonIDY(entities[num].id1, entities[num].y);

		if (entities[num].hp1 > 0)
		{
			SetPersonIDX(entities[num].id2, entities[num].x);
			SetPersonIDY(entities[num].id2, entities[num].y);
		}
		else
			SetPersonIDX(entities[num].id2, -100);
	
		if (entities[num].hp2 > 0)
		{
			SetPersonIDX(entities[num].id3, entities[num].x);
			SetPersonIDY(entities[num].id3, entities[num].y);
		}
		else
			SetPersonIDX(entities[num].id3, -100);
	}


}

function IsPersonOnGround(num)
{
	var test_x_off=0
	var test_id = entities[num].id1;
	if (entities[num].hp <=0&& (entities[num].type == 1 || entities[num].type == 3 || entities[num].type == 7))
	{
		test_id = g_widthy_id;
		test_x_off=entities[num].dir*4;
	}
	if (test_x_off == undefined)
		test_x_off = 0;


	var t_layer = GetPersonIDLayer(entities[num].id1);
	SetPersonIDLayer(entities[num].id1, 0);
	
	GetPersonIDX(test_id);

	if (IsPersonIDObstructed(test_id, entities[num].x+test_x_off, entities[num].y) == false && 
	IsPersonIDObstructed(test_id, entities[num].x+test_x_off, entities[num].y+1) == true)
	{
		SetPersonIDLayer(entities[num].id1, t_layer);
	  return true;
	}
	if (entities[num].type == 8 && IsEntityOnWater(num))
	{
		SetPersonIDLayer(entities[num].id1, t_layer);
	  return true;
	}
	SetPersonIDLayer(entities[num].id1, t_layer);
	return false;
}

var upod = 0;
var image = LoadImage("dot.png");

function update()
{
  upod++;
	SetPersonX("main_torso", GetPersonX("main_legs"));
	SetPersonY("main_torso", GetPersonY("main_legs"));
	
	SetPersonDirection("main_torso", "south");
	if (GetPersonDirection("main_legs") == "east")
		SetPersonDirection("main_torso", "north");
		
	if (!IsKeyPressed(KEY_RIGHT) && !IsKeyPressed(KEY_LEFT))
		SetPersonFrame("main_legs", 0);
	
		
	  angle = Math.atan2(GetMouseY()-120,160-GetMouseX())+3.14159;
	  
	  angle/=(2*3.14159);
	  
	  angle*=16;
	  angle+=0.5;
	  angle = Math.floor(angle);

		if (entities[0].dir == -1)
		{
			angle = -angle+8;
			if (angle<0)
			  angle+16;
			SetPersonFrame("main_torso", 0);//angle);
		}
		else
			SetPersonFrame("main_torso", angle);
}


		
function DroneSet()
{
	for (ds = 0;ds<max_entities;ds++)
	{
		if (entities[ds].nohit == true && entities[ds].type == 8)
		{
			SetPersonIDLayer(entities[ds].id1, 0);
			SetPersonIDLayer(entities[ds].id2, 0);
			SetPersonIDLayer(entities[ds].id3, 0);
		}
	}
}

function DroneReset()
{
	for (ds = 0;ds<max_entities;ds++)
	{
		if (entities[ds].nohit == true && entities[ds].type == 8)
		{
			SetPersonIDLayer(entities[ds].id1, entities[ds].layer);
			SetPersonIDLayer(entities[ds].id2, entities[ds].layer);
			SetPersonIDLayer(entities[ds].id3, entities[ds].layer);
		}
	}
}

